% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_taxon.R
\name{make_taxon}
\alias{make_taxon}
\title{Make taxon from class}
\usage{
make_taxon(genus = "none", epithet = "none", authority = "none", ...)
}
\arguments{
\item{genus}{Genus name, e.g., Homo (in Homo sapiens)}

\item{epithet}{Specific epithet, e.g., sapiens (in Homo sapiens)}

\item{authority}{Taxonomic authority}

\item{...}{Further args.}
}
\description{
Make taxon from class
}
\examples{
\dontrun{
(out <- make_taxon(genus="Poa"))
(out <- make_taxon(genus="Poa", epithet="annua", authority="L."))
(out <- make_taxon(genus="Poa", epithet="annua", authority="L.",
                   family='Poaceae', clazz='Poales', kingdom='Plantae', variety='annua'))
out$binomial
out$binomial$canonical
out$binomial$species
out$binomial$authority
out$grouping
out$grouping$family
out \%>\% pick(family) # get a single rank
out \%>\% span(kingdom, family) # get a range of ranks
gethier(out) # get hierarchy as data.frame

# Using dplyr
df <- data.frame(class=c('Magnoliopsida','Magnoliopsida','Magnoliopsida',
   'Magnoliopsida','Magnoliopsida','Magnoliopsida'),
 order=c('Asterales','Asterales','Fagales','Poales','Poales','Poales'),
 family=c('Asteraceae','Asteraceae','Fagaceae','Poaceae','Poaceae','Poaceae'),
 genus=c('Helianthus','Helianthus','Quercus','Poa','Festuca','Holodiscus'),
 species=c('annuus','petrus','kellog','annua','arundinaceae','fava'),
 stringsAsFactors = FALSE)

xx <- df \%>\% rowwise()
xx \%>\% do(i = strain(make_taxon(.$species, genus = .$genus), . < family)) \%>\% .[[1]]
xx \%>\% do(i = strain(make_taxon(.$species, genus = .$genus), . < genus)) \%>\% .[[1]]
xx \%>\% do(i = strain(make_taxon(.$species, genus = .$genus), . < species)) \%>\% .[[1]]
}
}

