% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binman_utils.R
\name{rm_platform}
\alias{rm_platform}
\title{Remove application platform}
\usage{
rm_platform(appname, platform = c("ALL"))
}
\arguments{
\item{appname}{A character string giving the name of the application}

\item{platform}{A character vector indicating the platform to remove.
Defaults to "ALL"}
}
\value{
Returns a logical vector indicating whether the removal of
    platform was successful. Return is invisible.
}
\description{
Remove application files/directories for a given platform
}
\examples{
\dontrun{
appdir <- app_dir(appname, FALSE)
platforms <- LETTERS[1:4]
versions <- LETTERS[5:7]
mkdirs <- file.path(appdir, outer(platforms, versions, file.path))
chk <- vapply(mkdirs, dir.create, logical(1), recursive = TRUE)
appver <- list_versions(appname)
rm_platform(appname, platforms[2:3])
unlink(appdir, recursive = TRUE)
}
}
