% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predl_templates.R
\name{predl_github_assets}
\alias{predl_github_assets}
\title{Pre download Github assets}
\usage{
predl_github_assets(url, platform, history, appname, platformregex = platform,
  versionregex = c("", ""))
}
\arguments{
\item{url}{A url giving the github asset JSON for a project. As an
example https://github.com/mozilla/geckodriver/releases the
geckodriver project has an asset JSON available at
https://api.github.com/repos/mozilla/geckodriver/releases}

\item{platform}{A character vector of platform names}

\item{history}{The maximum number of files to get for a platform}

\item{appname}{Name of the app}

\item{platformregex}{A filter for platforms. Defaults to the platform}

\item{versionregex}{A regex for retrieving the version.}
}
\value{
A named list of data.frames. The name indicates the
    platform. The data.frame should contain the version, url and file
    to be processed. Used as input for \code{\link{download_files}} or
    an equivalent.
}
\description{
Pre download Github assets template function
}
\examples{
\dontrun{
gadata <- system.file("testdata", "test_gitassets.json",
                      package="binman")
platform <- c("linux64", "win64", "macos")
gadllist <- predl_github_assets(url = gadata, platform, history = 3L,
                                appname = "binman_chromedriver")
}
}

