% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_eta.R
\name{func_eta}
\alias{func_eta}
\title{Function: Learning Rate}
\usage{
func_eta(
  i,
  L_freq,
  R_freq,
  L_pick,
  R_pick,
  L_value,
  R_value,
  var1 = NA,
  var2 = NA,
  value,
  utility,
  reward,
  occurrence,
  eta,
  alpha,
  beta
)
}
\arguments{
\item{i}{The current row number.}

\item{L_freq}{The frequency of left option appearance}

\item{R_freq}{The frequency of right option appearance}

\item{L_pick}{The number of times left option was picked}

\item{R_pick}{The number of times left option was picked}

\item{L_value}{The value of the left option}

\item{R_value}{The value of the right option}

\item{var1}{[character] 
Column name of extra variable 1. If your model uses more than just reward 
 and expected value, and you need other information, such as whether the 
 choice frame is Gain or Loss, then you can input the 'Frame' column as 
 var1 into the model.
 
 \code{default: var1 = "Extra_Var1"}}

\item{var2}{[character] 
Column name of extra variable 2. If one additional variable, var1, does not 
 meet your needs, you can add another additional variable, var2, into your 
 model.
 
 \code{default: var2 = "Extra_Var2"}}

\item{value}{The expected value of the stimulus in the subject's mind at this point in time.}

\item{utility}{The subjective value that the subject assigns to the objective reward.}

\item{reward}{The objective reward received by the subject after selecting a stimulus.}

\item{occurrence}{The number of times the same stimulus has been chosen.}

\item{eta}{[numeric]
Parameters used in the Learning Rate Function, \code{rate_func}, representing
 the rate at which the subject updates the difference (prediction error)
 between the reward and the expected value in the subject's mind.

 The structure of \code{eta} depends on the model type:
 \itemize{
   \item For the \strong{Temporal Difference (TD) model}, 
   where a single learning rate is used throughout the experiment 
   \deqn{V_{new} = V_{old} + \eta \cdot (R - V_{old})}
   
   \item For the \strong{Risk-Sensitive Temporal Difference (RDTD) model},
   where two different learning rates are used depending on whether the 
   reward is lower or higher than the expected value:
   \deqn{V_{new} = V_{old} + \eta_{+} \cdot (R - V_{old}), R > V_{old}}
   \deqn{V_{new} = V_{old} + \eta_{-} \cdot (R - V_{old}), R < V_{old}}
 }
 
 \code{TD: eta = 0.3}
 
 \code{RSTD: eta = c(0.3, 0.7)}}

\item{alpha}{[vector]
Extra parameters that may be used in functions.}

\item{beta}{[vector]
Extra parameters that may be used in functions.}
}
\value{
learning rate eta
}
\description{
The structure of \code{eta} depends on the model type:
 \itemize{
   \item \strong{Temporal Difference (TD) model}:
     \code{eta} is a single numeric value representing the learning rate.

   \item \strong{Risk-Sensitive Temporal Difference (RSTD) model}:
     \code{eta} is a numeric vector of length two, where 
     \code{eta[1]} represents the learning rate for "good" outcomes, which 
     means the reward is higher than the expected value.
     \code{eta[2]} represents the learning rate for "bad" outcomes, which 
     means the reward is lower than the expected value.
 }
}
\note{
When customizing these functions, please ensure that you do not modify 
 the arguments. Instead, only modify the `if-else` statements or the internal 
 logic to adapt the function to your needs.
}
\examples{
\dontrun{
func_eta <- function(
  # Trial number
  i,
  # Number of times this option has appeared
  L_freq,
  R_freq,
  # Number of times this option has been chosen
  L_pick,
  R_pick,
  # Current value of this option
  L_value,
  R_value,
  # Extra variables
  var1 = NA,
  var2 = NA,
  
  # Expected value for this stimulus
  value,
  # Subjective utility
  utility,
  # Reward observed after choice
  reward,
  # Occurrence count for this stimulus
  occurrence,
  
  # Free Parameter
  eta,
  # Extra parameters
  alpha,
  beta
){
################################# [ TD ] ####################################
  if (length(eta) == 1) {
    eta <- as.numeric(eta)
  }
################################ [ RSTD ] ###################################
  else if (length(eta) > 1 & utility < value) {
    eta <- eta[1]
  }
  else if (length(eta) > 1 & utility >= value) {
    eta <- eta[2]
  }
################################ [ ERROR ] ##################################
  else {
    eta <- "ERROR" # Error check
  }
  return(eta)
}
}

}
