% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenBinaryY.R
\name{GenBinaryY}
\alias{GenBinaryY}
\title{Generate binary response data from a Marginalized Transition and Latent Variable Model}
\usage{
GenBinaryY(
  mean.formula,
  lv.formula = NULL,
  t.formula = NULL,
  beta = NULL,
  sigma = NULL,
  gamma = NULL,
  id,
  data,
  q = 10
)
}
\arguments{
\item{mean.formula}{Right hand side of mean model formula}

\item{lv.formula}{Latent variable model formula (right hand side only)}

\item{t.formula}{Transition model formula (right hand side only)}

\item{beta}{a vector of values for mean.formula}

\item{sigma}{a vector of values for the latent variable portion of the association model (else NULL)}

\item{gamma}{a vector of values for the transition porition of the association model (else NULL)}

\item{id}{a vector of cluster identifiers (it should be the same length nrow(data))}

\item{data}{a required data frame}

\item{q}{a scalar to denote the number of quadrature points used for GH numerical integration}

}
\value{
The function returns a binary response vector.
}
\description{
Generate binary response data from a Marginalized Transition and Latent Variable Model
}
\examples{
\donttest{
set.seed(1)
N      = 100
nclust = sample( seq(10,10), N, replace=TRUE)
id     = rep(seq(N), nclust)
Xe     = rep(rbinom(N,size=1,prob=.5), nclust) # binary exposure
time   = unlist( sapply( as.list(nclust), function(ZZ) seq(ZZ)-1 ) )
data   = data.frame(id, time, Xe)
data   = data[order(data$id, data$time),]
newdata = GenBinaryY(mean.formula=~time*Xe, lv.formula=~1, t.formula=~1,
beta=c(-2.5, 0.25, 0.25, 0.1), sigma=1, gamma=1, id=id, data=data, q=20)}

}
