% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binHelper.R
\name{binaryPrefix}
\alias{binaryPrefix}
\title{Binary prefix (KiB,MiB,..)}
\usage{
binaryPrefix(n, prefix="KiB")
}
\arguments{
\item{n}{numeric value}

\item{prefix}{binary prefix * byte. Expeting a »string«}
}
\value{
The number of byte fitting in n * binary prefix * byte
}
\description{
Num of byte needed to fit in n * KiB, MiB ..etc.
}
\details{
KiB <- KibiByte
MiB <- MebiByte
GiB <- GibiByte
TiB <- TebiByte
PiB <- PebiByte
EiB <- ExiByte
ZiB <- ZebiByte
YiB <- YobiByte
}
\examples{
#Get the number of byte needed to hold 0.5 and 1:10 KiB
binaryPrefix(c(0.5,1:10),"KiB")
#Get the number of bit needed to hold 1 KiB
binaryPrefix(1,"KiB")*byte()
}
\seealso{
\link{bytesNeeded} or \link{fillUpToByte} or \link{byte}
}

