% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assoc-bgen.R
\name{snp_assocBGEN}
\alias{snp_assocBGEN}
\title{Compute quick association statistics from BGEN files}
\usage{
snp_assocBGEN(
  bgenfiles,
  list_snp_id,
  y_row,
  ind_row,
  bgi_dir = dirname(bgenfiles),
  ncores = 1
)
}
\arguments{
\item{bgenfiles}{Character vector of paths to files with extension ".bgen".
The corresponding ".bgen.bgi" index files must exist.}

\item{list_snp_id}{List (same length as the number of BGEN files) of
character vector of SNP IDs to read. These should be in the form
\code{"<chr>_<pos>_<a1>_<a2>"} (e.g. \code{"1_88169_C_T"} or \code{"01_88169_C_T"}).
\strong{This function assumes that these IDs are uniquely identifying variants.}}

\item{y_row}{A vector corresponding to \code{ind_row} and representing the trait
with which to compute correlations.
Missing values in either \code{ind_row} or \code{y_row} are removed.}

\item{ind_row}{A vector of the row indices (individuals) that are used.
Missing values in either \code{ind_row} or \code{y_row} are removed.
\strong{Make sure to use indices corresponding to your training set only.}}

\item{bgi_dir}{Directory of index files. Default is the same as \code{bgenfiles}.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \code{\link[=nb_cores]{nb_cores()}}.}
}
\value{
A list of vectors of log10(p-values) corresponding to the statistic
\eqn{n \times r^2}, where r is the correlation of each variant with \code{y_row}.
}
\description{
\strong{THIS FUNCTION WILL BE MODIFIED IN THE FUTURE.}
}
