% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{big_fread2}
\alias{big_fread2}
\title{Read large text file}
\usage{
big_fread2(file, nb_parts, .transform = identity, .combine = cbind_df,
  skip = 0, select = NULL, ...)
}
\arguments{
\item{file}{Path to file that you want to read.}

\item{nb_parts}{Number of parts in which to split reading (and transforming).
Parts are referring to blocks of selected columns.}

\item{.transform}{Function to transform each data frame corresponding to each
block of selected columns. Default doesn't change anything.}

\item{.combine}{Function to combine results (list of data frames).}

\item{skip}{Number of lines to skip at the beginning of \code{file}.}

\item{select}{Indices of columns to keep (sorted). Default keeps them all.}

\item{...}{Other arguments to be passed to \link[data.table:fread]{data.table::fread},
excepted \code{input}, \code{file}, \code{skip} and \code{select}.}
}
\value{
A \code{data.frame} by default; a \code{data.table} when \code{data.table = TRUE}.
}
\description{
Read large text file by splitting columns.
}
