% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vctrs-math.R
\name{bignum-math}
\alias{bignum-math}
\title{Mathematical operations}
\value{
The returned value depends on the individual function. We recommend
reading the base R documentation for a specific function to understand
the expected result.
}
\description{
\link{biginteger} and \link{bigfloat} vectors support many of the standard mathematical
operations. The base R documentation can be found by searching for the
individual functions (e.g. \code{\link[=mean]{mean()}}).
}
\examples{
# summary
x <- bigfloat(1:5)
sum(x)
prod(x)
max(x)
min(x)
range(x)
mean(x)

# cumulative
x <- bigfloat(1:5)
cumsum(x)
cumprod(x)
cummax(x)
cummin(x)

# rounding
x <- bigfloat(1.5)
floor(x)
ceiling(x)
trunc(x)

# miscellaneous
x <- bigfloat(2)
abs(x)
sign(x)
sqrt(x)

# logarithms and exponentials
x <- bigfloat(2)
log(x)
log10(x)
log2(x)
log1p(x)
exp(x)
expm1(x)

# trigonometric
x <- bigfloat(0.25)
cos(x)
sin(x)
tan(x)
acos(x)
asin(x)
atan(x)
cospi(x)
sinpi(x)
tanpi(x)

# hyperbolic
x <- bigfloat(0.25)
cosh(x)
sinh(x)
tanh(x)
acosh(bigfloat(2))
asinh(x)
atanh(x)

# special functions
x <- bigfloat(2.5)
gamma(x)
lgamma(x)
digamma(x)
trigamma(x)
factorial(x)
lfactorial(x)
}
\seealso{
Other bignum operations: 
\code{\link{bignum-arith}},
\code{\link{bignum-compare}},
\code{\link{bignum-special}}
}
\concept{bignum operations}
