% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigleaf_physiology.r
\name{stomatal.sensitivity}
\alias{stomatal.sensitivity}
\title{Stomatal Sensitivity to VPD}
\usage{
stomatal.sensitivity(data, Gs = "Gs_mol", VPD = "VPD", ...)
}
\arguments{
\item{data}{Data.frame or matrix containing all required columns}

\item{Gs}{Surface conductance to water vapor (mol m-2 s-1)}

\item{VPD}{Vapor pressure deficit (kPa)}

\item{...}{Additional arguments to \code{\link[stats]{nls}}}
}
\value{
A \code{nls} model object containing (amongst others) estimates for the mean
        and standard errors of the parameters m and b.
}
\description{
Sensitivity of surface conductance to vapor pressure deficit.
}
\details{
The function fits the following equation (Oren et al. 1999):

            \deqn{Gs = -m ln(VPD) + b}

         where b is the reference surface conductance (Gs) at VPD=1kPa (in mol m-2 s-1),
         and m is the sensitivity parameter of Gs to VPD (in mol m-2 s-1 log(kPa)-1).
         The two parameters b and m are fitted using \code{\link[stats]{nls}}.
         VPD can be the one directly measured at instrument height, or the
         one at the surface, as returned by \code{\link{surface.conditions}}.
}
\examples{
## calculate Ga, Gs, and the stomatal sensitivity to VPD for the site FR-Pue in
## May 2012. Data are filtered for daytime, sufficiently high ustar, etc.
FR_Pue_May_2012_2 <- filter.data(FR_Pue_May_2012,quality.control=TRUE,
                                 vars.qc=c("Tair","precip","H","LE"),
                                 filter.growseas=FALSE,filter.precip=TRUE,
                                 filter.vars=c("Tair","PPFD","ustar","VPD"),
                                 filter.vals.min=c(5,200,0.2,0.3),
                                 filter.vals.max=c(NA,NA,NA,NA),
                                 NA.as.invalid=TRUE,quality.ext="_qc",
                                 good.quality=c(0,1),missing.qc.as.bad=TRUE,
                                 precip="precip",tprecip=0.1,precip.hours=24,
                                 records.per.hour=2)
Ga <- aerodynamic.conductance(FR_Pue_May_2012_2)
Gs <- surface.conductance(FR_Pue_May_2012_2,Ga=Ga[,"Ga_h"])
stomatal.sensitivity(FR_Pue_May_2012_2,Gs=Gs[,"Gs_mol"],VPD="VPD")

}
\references{
Oren R., et al. 1999: Survey and synthesis of intra- and interspecific
            variation in stomatal sensitivity to vapour pressure deficit. Plant,
            Cell & Environment 22, 1515-1526. 
            
            Novick K.A., et al. 2016: The increasing importance of atmospheric demand
            for ecosystem water and carbon fluxes. Nature Climate Change 6, 1023 - 1027.
}
\seealso{
\code{\link{surface.conductance}}
}
