% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgg_tools.R
\name{bgg_merge}
\alias{bgg_merge}
\title{Merge data from two bggAPI objects}
\usage{
bgg_merge(x, y, ...)
}
\arguments{
\item{x, y}{objects that inherit from \code{bggAPI} class.}

\item{...}{other arguments passed to \code{\link[data.table]{merge}}.}
}
\value{
A data.table with variables from both \code{x} and \code{y}.
}
\description{
This allows for merging data from two bggAPI objects. Namestyle is inherited
from \code{x} and columns from \code{y$data} are added to \code{x$data}
(unless they are already there).
}
\examples{

sr <- bggSearch$new("Terraforming Mars")
gm <- bggGames$new(sr$ids)

gm$expand(c("name", "type", "rank"))

bgg_merge(sr, gm)

}
