% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_nominal.R
\name{PlotNominal}
\alias{PlotNominal}
\title{Plot Nominal}
\usage{
PlotNominal(data, monochrome = TRUE, plot.colors = c("#CCCCCC",
  "#DEDEDE"), font.type = "serif", bar.dodge = 0.6, bar.alpha = 0.7,
  bar.width = 0.4, bar.extras.dodge = 0, bar.border = "black",
  bar.label = FALSE, bar.error = TRUE, use.cutoff = FALSE,
  diff.cutoff = 1, q.items = NULL)
}
\arguments{
\item{data}{MCMC data to plot}

\item{monochrome}{logical, indicating whether or not to use monochrome colors, else use \link[bfw]{DistinctColors}, Default: TRUE}

\item{plot.colors}{range of color to use, Default: c("#CCCCCC", "#DEDEDE")}

\item{font.type}{font type used for visualizations, Default: 'serif'}

\item{bar.dodge}{distance between within bar plots, Default: 0.6}

\item{bar.alpha}{transparency for bar plot, Default: 0.7}

\item{bar.width}{width of bar plot, Default: 0.4}

\item{bar.extras.dodge}{dodge of error bar and label, Default: 0}

\item{bar.border}{color of the bar border, Default: 'black'}

\item{bar.label}{logical, indicating whether or not to show bar labels, Default: TRUE}

\item{bar.error}{logical, indicating whether or not to show error bars, Default: TRUE}

\item{use.cutoff}{logical, indicating whether or not to use a cutoff for keeping plots, Default: FALSE}

\item{diff.cutoff}{if using a cutoff, determine the percentage that expected and observed values should differ, Default: 1}

\item{q.items}{which variables should be used in the plot. Defaults to all , Default: NULL}
}
\description{
Create a nominal plot
}
\seealso{
\code{\link[ggplot2]{aes}},\code{\link[ggplot2]{margin}},\code{\link[ggplot2]{geom_crossbar}},\code{\link[ggplot2]{ggplot}},\code{\link[ggplot2]{scale_manual}},\code{\link[ggplot2]{theme}}
}
