% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfsl.R
\name{bfsl}
\alias{bfsl}
\title{Calculates the Best-fit Straight Line}
\usage{
bfsl(x, y = NULL, sd_x = 0, sd_y = 1, r = 0, control = bfsl_control())
}
\arguments{
\item{x}{A vector of \emph{x} observations or a data frame (or an
object coercible by \code{\link{as.data.frame}} to a data frame) containing
the named vectors \emph{x}, \emph{y}, and optionally \emph{sd_x},
\emph{sd_y} and \emph{r}. If weights \emph{w_x} and \emph{w_y} are given,
then \emph{sd_x} and \emph{sd_y} are calculated from \emph{sd_x = 1/sqrt(w_x)}
and \emph{sd_y = 1/sqrt(w_y)}. Specifying \code{y}, \code{sd_x}, \code{sd_y}
or \code{r} directly as function arguments overwrites these variables in the
data structure.}

\item{y}{A vector of \emph{y} observations.}

\item{sd_x}{A vector of \emph{x} measurement error standard
deviations. If it is of length one, all data points are assumed to have the
same \emph{x} standard deviation.}

\item{sd_y}{A vector of \emph{y} measurement error standard
deviations. If it is of length one, all data points are assumed to have the
same \emph{y} standard deviation.}

\item{r}{A vector of correlation coefficients between errors in
\emph{x} and \emph{y}. If it is of length one, all data points are assumed to
have the same correlation coefficient.}

\item{control}{A list of control settings. See \code{\link{bfsl_control}}
for the names of the settable control values and their effect.}
}
\value{
An object of class "\code{bfsl}", which is a \code{list} containing
the following components:
\item{coefficients}{A \code{2x2} matrix with columns of the fitted coefficients
(intercept and slope) and their standard errors.}
\item{chisq}{The goodness of fit  (see Details).}
\item{control}{The control \code{list} used, see the \code{control} argument.}
\item{convInfo}{A \code{list} with convergence information.}
\item{call}{The matched call.}
\item{data}{A \code{list} containing \code{x}, \code{y}, \code{sd_x}, \code{sd_y}
and \code{r}.}
}
\description{
\code{bfsl} calculates the best-fit straight line to independent points with
(possibly correlated) normally distributed errors in both coordinates.
}
\details{
\code{bfsl} provides the general least-squares estimation solution to the
problem of fitting a straight line to independent data with (possibly
correlated) normally distributed errors in both \code{x} and \code{y}.

With \code{sd_x = 0} the (weighted) ordinary least squares solution is
obtained. The calculated standard errors of the slope and intercept
multiplied with \code{sqrt(chisq)} correspond to the ordinary least squares
standard errors.

With \code{sd_x = c}, \code{sd_y = d}, where \code{c} and \code{d} are
positive numbers, and \code{r = 0} the Deming regression solution is obtained.
If additionally \code{c = d}, the orthogonal distance regression solution,
also known as major axis regression, is obtained.

Setting \code{sd_x = sd(x)}, \code{sd_y = sd(y)} and \code{r = 0} leads to
the geometric mean regression solution, also known as reduced major
axis regression or standardised major axis regression.

The goodness of fit metric \code{chisq} is a weighted reduced chi-squared
statistic. It compares the deviations of the points from the fit line to the
assigned measurement error standard deviations. If \code{x} and \code{y} are
indeed related by a straight line, and if the assigned measurement errors
are correct (and normally distributed), then \code{chisq} will equal 1. A
\code{chisq > 1} indicates underfitting: the fit does not fully capture the
data or the measurement errors have been underestimated. A \code{chisq < 1}
indicates overfitting: either the model is improperly fitting noise, or the
measurement errors have been overestimated.
}
\examples{
x = pearson_york$x
y = pearson_york$y
sd_x = 1/sqrt(pearson_york$w_x)
sd_y = 1/sqrt(pearson_york$w_y)
bfsl(x, y, sd_x, sd_y)

fit = bfsl(pearson_york)
plot(fit)

}
\references{
York, D. (1968). Least squares fitting of a straight line with
correlated errors. \emph{Earth and Planetary Science Letters}, 5, 320–324,
https://doi.org/10.1016/S0012-821X(68)80059-7
}
