% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaNB-p-cor-nb.R
\name{PCorNB}
\alias{PCorNB}
\title{Estimate Squared Partial Correlation Coefficients
and Generate the Corresponding Sampling Distribution
Using Nonparametric Bootstrapping}
\usage{
PCorNB(object)
}
\arguments{
\item{object}{Object of class \code{mc}, that is,
the output of the \code{MC()} function.}
}
\value{
Returns an object
of class \code{betanb} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{object}{The function argument \code{object}.}
\item{thetahatstar}{Sampling distribution of
\eqn{r^{2}_{p}}.}
\item{vcov}{Sampling variance-covariance matrix of
\eqn{r^{2}_{p}}.}
\item{est}{Vector of estimated
\eqn{r^{2}_{p}}.}
\item{fun}{Function used ("PCorMC").}
}
}
\description{
Estimate Squared Partial Correlation Coefficients
and Generate the Corresponding Sampling Distribution
Using Nonparametric Bootstrapping
}
\details{
The vector of squared partial correlation coefficients
(\eqn{r^{2}_{p}})
is estimated from bootstrap samples.
Confidence intervals are generated by obtaining
percentiles corresponding to \eqn{100(1 - \alpha)\%}
from the generated sampling
distribution of \eqn{r^{2}_{p}},
where \eqn{\alpha} is the significance level.
}
\examples{
# Fit the regression model
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
# Generate the sampling distribution of sample covariances
# (use a large R, for example, R = 5000 for actual research)
nb <- NB(object, R = 50)
# Generate confidence intervals for standardized regression slopes
rp <- PCorNB(nb)
# Methods --------------------------------------------------------
print(rp)
summary(rp)
coef(rp)
vcov(rp)
confint(rp, level = 0.95)
}
\seealso{
Other Beta Nonparametric Bootstrap Functions: 
\code{\link{.CI}()},
\code{\link{BetaNB}()},
\code{\link{DeltaRSqNB}()},
\code{\link{DiffBetaNB}()},
\code{\link{NB}()},
\code{\link{RSqNB}()},
\code{\link{SCorNB}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Nonparametric Bootstrap Functions}
\keyword{betaNB}
\keyword{pcor}
