% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaMC-p-cor-mc.R
\name{PCorMC}
\alias{PCorMC}
\title{Estimate Squared Partial Correlation Coefficients
and Generate the Corresponding Sampling Distribution
Using the Monte Carlo Method}
\usage{
PCorMC(object, alpha = c(0.05, 0.01, 0.001))
}
\arguments{
\item{object}{Object of class \code{mc}, that is,
the output of the \code{MC()} function.}

\item{alpha}{Numeric vector.
Significance level \eqn{\alpha}.}
}
\value{
Returns an object
of class \code{betamc} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{Function arguments.}
\item{thetahatstar}{Sampling distribution of
\eqn{r^{2}_{p}}.}
\item{vcov}{Sampling variance-covariance matrix of
\eqn{r^{2}_{p}}.}
\item{est}{Vector of estimated
\eqn{r^{2}_{p}}.}
\item{fun}{Function used ("PCorMC").}
}
}
\description{
Estimate Squared Partial Correlation Coefficients
and Generate the Corresponding Sampling Distribution
Using the Monte Carlo Method
}
\details{
The vector of squared partial correlation coefficients
(\eqn{r^{2}_{p}})
is derived from each randomly generated vector of parameter estimates.
Confidence intervals are generated by obtaining
percentiles corresponding to \eqn{100(1 - \alpha)\%}
from the generated sampling
distribution of \eqn{r^{2}_{p}},
where \eqn{\alpha} is the significance level.
}
\examples{
# Data ---------------------------------------------------------------------
data("nas1982", package = "betaMC")

# Fit Model in lm ----------------------------------------------------------
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)

# MC -----------------------------------------------------------------------
mc <- MC(
  object,
  R = 100, # use a large value e.g., 20000L for actual research
  seed = 0508
)

# PCorMC -------------------------------------------------------------------
out <- PCorMC(mc, alpha = 0.05)

## Methods -----------------------------------------------------------------
print(out)
summary(out)
coef(out)
vcov(out)
confint(out, level = 0.95)

}
\seealso{
Other Beta Monte Carlo Functions: 
\code{\link{BetaMC}()},
\code{\link{DeltaRSqMC}()},
\code{\link{DiffBetaMC}()},
\code{\link{MCMI}()},
\code{\link{MC}()},
\code{\link{RSqMC}()},
\code{\link{SCorMC}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Monte Carlo Functions}
\keyword{betaMC}
\keyword{pcor}
