% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaDelta-methods-diff-beta-delta.R
\name{confint.diffbetadelta}
\alias{confint.diffbetadelta}
\title{Confidence Intervals for Differences
of Standardized Regression Slopes}
\usage{
\method{confint}{diffbetadelta}(object, parm = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{Object of class \code{diffbetadelta}.}

\item{parm}{a specification of which parameters
are to be given confidence intervals,
either a vector of numbers or a vector of names.
If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{...}{additional arguments.}
}
\value{
Returns a matrix of confidence intervals.
}
\description{
Confidence Intervals for Differences
of Standardized Regression Slopes
}
\examples{
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
std <- BetaDelta(object)
diff <- DiffBetaDelta(std)
confint(diff)
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
