% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funSource.R
\name{funSource}
\alias{funSource}
\title{Source code of a function}
\usage{
funSource(x, character.only = is.character(x), trydirect = TRUE)
}
\arguments{
\item{x}{function name, with or without quotation marks}

\item{character.only}{If TRUE, look for SomeFun instead of MyFun if
MyFun <- "SomeFun". DEFAULT: \code{\link{is.character}(x)}}

\item{trydirect}{If TRUE, try direct urls to files \code{x.R} and \code{x.r}. DEFAULT: TRUE}
}
\value{
links that are also opened with \code{\link{browseURL}}
}
\description{
open source code of a function in a loaded or specified package on github.com/cran or github.com/wch/r-source
}
\examples{
\dontrun{ ## browser windows should not be openend in CRAN checks
library("berryFunctions")
funSource(colPoints)
funSource("head")
funSource("require", trydirect=FALSE)

funSource(earthDist)
funSource(OSMscale::earthDist)
funSource("OSMscale::earthDist")
}

\dontrun{ # developmental testing
require(plotrix); require(scales)
funSource(rescale

tail <- function(...) stop("This is a dummy function. Type: rm(tail)")
funSource("tail")
rm(tail)
}

}
\seealso{
\url{https://github.com/brry/rskey} to add this as a keyboard shortcut
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jan+Dec 2016
}
