% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaPlot.R
\name{betaPlot}
\alias{betaPlot}
\title{Beta density plot}
\usage{
betaPlot(shape1 = 1.5, shape2 = 5, lines = NA, fill = rgb(0, 0.3, 0.8,
  0.4), cumulative = TRUE, mar = c(2, 3, 3, 3), keeppar = FALSE,
  las = 1, main = paste("Beta density with\\nalpha =", signif(shape1, 3),
  "and beta =", signif(shape2, 3)), ylim = lim0(y), xlim = 0:1, ylab = "",
  xlab = "", type = "l", lty = 1, col = par("fg"), ...)
}
\arguments{
\item{shape1}{Alpha value as in \code{\link{dbeta}}. DEFAULT: 1.5}

\item{shape2}{Beta value. DEFAULT: 5}

\item{lines}{Quantiles at which vertical lines should be plotted. DEFAULT: NA}

\item{fill}{Color passed to \code{\link{polygon}}. DEFAULT: rgb(0,0.3,0.8, 0.4)}

\item{cumulative}{Should cumulative density distribution be added? DEFAULT: TRUE}

\item{mar}{Margins for plot passed to \code{\link{par}}. DEFAULT: c(2,3,3,3)}

\item{keeppar}{Should margin parameters be kept instead of being restored to previous value? DEFAULT: FALSE}

\item{las}{Label orientation, argument passed to \code{\link{plot}}. DEFAULT: 1}

\item{main}{main as in \code{\link{plot}}. DEFAULT: paste("Beta density with\\nalpha =", shape1, "and beta =", shape2)}

\item{ylim, xlim}{limit for the y and x axis. DEFAULT: lim0(y), 0:1}

\item{ylab, xlab}{labels for the axes. DEFAULT: ""}

\item{type, lty, col}{arguments passed to \code{\link{plot}} and \code{\link{lines}}.}

\item{\dots}{further arguments passed to \code{\link{plot}} like lwd, xaxs, cex.axis, etc.}
}
\value{
None. Used for plotting.
}
\description{
Quick and nice plot of beta density distribution based on just alpha and beta
}
\details{
This function very quickly plots a beta distribution by just specifying alpha and beta.
}
\examples{

betaPlot()
betaPlot(2,1) 
betaPlot(0.5, 2)

# beta distribution is often used for proportions or probabilities
# overview of parameters
# alpha = number of successes + 1.  beta = number of failures + 1
betaPlotComp()
# a bigger: HDI (Highest Density Interval) further to the right (1)
# b bigger: HDI more to the left (0)
# both bigger: narrower HDI, stronger peak

}
\seealso{
\code{\link{betaPlotComp}}, \code{\link{normPlot}}, \code{\link{dbeta}}, 
   \url{https://cran.r-project.org/package=denstrip}, 
   \url{https://cran.r-project.org/view=Distributions}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, July 2014
}
\keyword{distribution}
\keyword{hplot}
