% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stitch.R
\name{stitch_on}
\alias{stitch_on}
\title{Stitch behavioural data by putting together the same individuals recorded over different experiments
on the basis of a user-defined identifier}
\usage{
stitch_on(x, on, time_ref = "datetime", use_time = F, time_variable = "t")
}
\arguments{
\item{x}{\link{behavr} object}

\item{on}{name of a metavariable serving as a unique id (per individual)}

\item{time_ref}{name of a metavariable used to align time (e.g. \code{"date"}, or \code{"datetime"})}

\item{use_time}{whether to use time as well as date}

\item{time_variable}{name of the variable describing time}
}
\value{
a \link{behavr} table
}
\description{
This function can merge rows of data from the same individual that was recorded over multiple experiments.
A usual scenario in which \code{stitch_on} can be used is when an experiment is interrupted and a new recording is started
on the same biological subjects.
Stitching assumes the users has defined a \emph{unique id} in the metadata that refers to a specific individual.
Then, if any data that comes from the same unique id, it is merged.
}
\details{
When several rows of the metadata match a unique id (several experiments),
the first (in time) experiment is used as the reference id.
The data from the following one(s) will be added with a time lag equals to the difference between
the values of \code{time_ref}.
When data is not aligned to circadian time, it makes sense to set \code{use_time = TRUE}.
Otherwise, the assumption is that the time is already aligned to a circadian reference,
so only the date is used.
}
\examples{
set.seed(1)
met1 <- data.table::data.table(uid = 1:5,id = 1:5,
                               condition = letters[1:5],
                               sex = c("M", "M", "M", "F", "F"),
                               key = "id")
met2 <- data.table::data.table(uid = 1:4, id = 6:9,
                               condition = letters[1:4],
                               sex=c("M", "M", "M", "F"),
                               key = "id")
met1[, datetime := as.POSIXct("2015-01-02")]
met2[, datetime := as.POSIXct("2015-01-03")]
met <- rbind(met1, met2)
data.table::setkeyv(met, "id")
t <- 1L:100L
data <- met[,list(t = t,
                  x = rnorm(100),
                  y = rnorm(100),
                  eating = runif(100) > .5 ),
            by = "id"]
d <- behavr(data, met)
summary(d)
d2 <- stitch_on(d, on = "uid")
summary(d2)

}
\seealso{
\itemize{
\item \link{behavr} -- to formally create a behavr object
}
}
