% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_beast2.R
\name{check_beast2}
\alias{check_beast2}
\title{Check if \code{BEAST2} is installed properly.}
\usage{
check_beast2(beast2_path = get_default_beast2_path())
}
\arguments{
\item{beast2_path}{name of either a BEAST2 binary file
(usually simply \code{beast})
or a BEAST2 jar file
(usually has a \code{.jar} extension).
Use \link{get_default_beast2_bin_path} to get
the default BEAST binary file's path
Use \link{get_default_beast2_jar_path} to get
the default BEAST jar file's path}
}
\value{
nothing
}
\description{
Calls \code{stop} if BEAST2 is improperly installed
}
\examples{
if (is_beast2_installed()) {
  check_beast2()
}
}
\author{
Richèl J.C. Bilderbeek
}
