% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel_information.R
\name{load_panel}
\alias{load_panel}
\title{Load panel information}
\usage{
load_panel(.file_name = NULL, .panel_name = NULL, .panel_pattern = NULL)
}
\arguments{
\item{.file_name}{Character vector giving the name of an external panel info
file. See below for the expected components.}

\item{.panel_name}{Character vector giving the name of the panel. See below
for accepted panel names.}

\item{.panel_pattern}{The pattern to look for. Can be a regular expression.}
}
\value{
A \code{list}
}
\description{
The panel information are stored in \code{resources} in the package directory
and can be loaded by providing a file or panel name, or a search pattern
}
\details{
If an explicit \code{.file_name} is given, \code{.panel_name} and
\code{.panel_pattern} are ignored. If no file is given but a
\code{.panel_name} is, the \code{.panel_pattern} i ignored. Only if no
\code{.file_name} and \code{.panel_name} are given, is the
\code{.panel_pattern} used.
}
\section{Included panels}{


\itemize{
\item Human Adipokine Panel* (13-plex)
\item Human Anti-Virus Response Panel (13-plex)
\item Human CD8/NK Panel (13-plex)
\item Human Cytokine Panel 2 (13-plex)
\item Human Growth Factor Panel (13-plex)
\item Human Inflammation Panel (13-plex)
\item Human Metabolic Panel 1 (4-plex)
\item Human Proinflammatory Chemokine Panel (13-plex)
\item Human T Helper Cytokine Panels (13-plex)
\item Mouse Anti-Virus Response Panel (13-plex)
\item Mouse Cytokine Panel 2 (13-plex)
\item Mouse Free Active/Total TGF-b1 Panel (Mouse/Rat) (1-plex)
\item Mouse HSC Panel (13-plex)
\item Mouse IgE Panel (1-plex)
\item Mouse Immunoglobulin Isotyping Panel (6-plex)
\item Mouse Inflammation Panel (13-plex)
\item Mouse Proinflammatory Chemokine Panel (13-plex)
\item Mouse T Helper Cytokine Panels (13-plex)
}
}

\section{Example panel file}{


The panel information files are formatted in YAML. It has three main parts:
\itemize{
\item Some general information about the panel - The order of the major bead
groups in the forward and side scatter - Analytes, where each bead ID is
listed for each major bead group. The bead IDs are further complemented
with the name of the analyte and the start concentration of the standard
value
}

The 'Human Th Cytokine Panel (13-plex)' YAML file is found in
\code{/resources/legendplex_human_th_cytokine_panel_13-plex.yml} of the
package directory.
}

\examples{
library(beadplexr)

.panel_name <- "Human T Helper Cytokine Panels (13-plex)"
panel_info <- load_panel(.panel_name = .panel_name)
panel_info$panel_name

.file_name <- system.file("resources",
                          "legendplex_human_cytokine_panel_2_13-plex.yml",
                          package = "beadplexr")
panel_info <- load_panel(.file_name = .file_name)
panel_info$panel_name

panel_info <- load_panel(.file_name = .file_name, .panel_name = .panel_name)
panel_info$panel_name

panel_info <- load_panel(.panel_pattern = "panel_2_13-plex")
panel_info$panel_name

}
