% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getcellid.R
\name{getcellid}
\alias{getcellid}
\title{Assign GBIF style degree cell ids and generate custom grid cell ids}
\usage{
getcellid(indf, gridscale = 0)
}
\arguments{
\item{indf}{input data frame containing biodiversity data set}

\item{gridscale}{generate custom grid scale column for mapping. Default is 0.}
}
\description{
Calculate and assign a GBIF-style degree cell id and centi-degree (0.1 
degrees, dividing a 1 degree cell into 100 centi-degree cells) cell id to each
record. This function also creates a custom grid scale if parameter gridscale 
is supplied. This is a necessary previous step for some functions like
\code{\link{mapgrid}}
}
\examples{
\dontrun{
getcellid(inat)
}
}
\seealso{
Other Data preparation functions: 
\code{\link{bdsummary}()},
\code{\link{format_bdvis}()},
\code{\link{gettaxo}()}
}
\concept{Data preparation functions}
