% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preparation.R
\name{feature_standardization}
\alias{feature_standardization}
\title{Perform feature standarization}
\usage{
feature_standardization(
  df,
  timestamp_col,
  entity_col,
  time_effects = FALSE,
  scale = TRUE
)
}
\arguments{
\item{df}{Dataframe with data that should be prepared for LIML estimation}

\item{timestamp_col}{Column with timestamps (e.g. years)}

\item{entity_col}{Column with entities (e.g. countries)}

\item{time_effects}{Whether to introduce time fixed effects
(by cross-sectional demeaning)}

\item{scale}{Whether to divide by the standard deviation \code{TRUE} or not
\code{FALSE}. Default is \code{TRUE}.}
}
\value{
A dataframe with standardized features
}
\description{
This function performs
\href{https://en.wikipedia.org/wiki/Feature_scaling}{feature standarization}
(also known as z-score normalization), i.e. the features are centered around
the mean and scaled with standard deviation.
}
\examples{
df <- data.frame(
  year = c(2000, 2001, 2002, 2003, 2004),
  country = c("A", "A", "B", "B", "C"),
  gdp = c(1, 2, 3, 4, 5),
  ish = c(2, 3, 4, 5, 6),
  sed = c(3, 4, 5, 6, 7)
)

feature_standardization(df, year, country)

}
