% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tournament_methods.R
\name{plot.tournament}
\alias{plot.tournament}
\title{Plot method for discharge rating curve tournament}
\usage{
\method{plot}{tournament}(x, type = "tournament_results", transformed = FALSE, ...)
}
\arguments{
\item{x}{an object of class "tournament"}

\item{type}{a character denoting what type of plot should be drawn. Possible types are
\itemize{
  \item{"deviance"}{ to plot the deviance of the four models.}
  \item{"rating_curve"}{ to plot the rating curve.}
  \item{"rating_curve_mean"}{ to plot the posterior mean of the rating curve.}
  \item{"f"}{ to plot the power-law exponent.}
  \item{"sigma_eps"}{ to plot the standard deviation on the data level.}
  \item{"residuals"}{ to plot the log residuals.}
  \item{"residuals"}{ to plot tournament results visually, game for game.}
 }}

\item{transformed}{a logical value indicating whether the quantity should be plotted on a transformed scale used during the Bayesian inference. Defaults to FALSE.}

\item{...}{further arguments passed to other methods.}
}
\value{
No return value, called for side effects
}
\description{
Compare the four models from the tournament object in multiple ways
}
\examples{
\donttest{
data(krokfors)
set.seed(1)
t_obj <- tournament(formula=Q~W,data=krokfors,num_cores=2)
plot(t_obj)
plot(t_obj,transformed=TRUE)
plot(t_obj,type='deviance')
plot(t_obj,type='f')
plot(t_obj,type='sigma_eps')
plot(t_obj,type='residuals')
plot(t_obj,type='tournament_results')
}
}
\seealso{
\code{\link{tournament}} to run a discharge rating curve tournament and \code{\link{summary.tournament}} for summaries.
}
