% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InterjectionPipe.R
\name{InterjectionPipe}
\alias{InterjectionPipe}
\title{Class to find and/or remove the interjections on the data field of an Instance}
\description{
\code{\link{InterjectionPipe}} class is responsible for detecting
the existing interjections in the \strong{data} field of each \code{\link{Instance}}.
Identified interjections are stored inside the \strong{interjection} field of
\code{\link{Instance}} class. Moreover if needed, is able to perform inline
interjections removement.
}
\section{Details}{

\code{\link{InterjectionPipe}} class requires the resource files (in json format)
containing the list of interjections. To this end, the language of the text
indicated in the \emph{propertyLanguageName} should be contained in the
resource file name (ie. interj.xxx.json where xxx is the value defined in the
\emph{propertyLanguageName} ). The location of the resources should be
defined in the \strong{"resources.interjections.path"} field of
\emph{\link{bdpar.Options}} variable.
}

\section{Note}{

\code{\link{InterjectionPipe}} will automatically invalidate the
\code{\link{Instance}} whenever the obtained data is empty.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{bdpar.Options}},
         \code{\link{ContractionPipe}}, \code{\link{File2Pipe}},
         \code{\link{FindEmojiPipe}}, \code{\link{FindEmoticonPipe}},
         \code{\link{FindHashtagPipe}}, \code{\link{FindUrlPipe}},
         \code{\link{FindUserNamePipe}}, \code{\link{GuessDatePipe}},
         \code{\link{GuessLanguagePipe}}, \code{\link{Instance}},
         \code{\link{MeasureLengthPipe}}, \code{\link{GenericPipe}},
         \code{\link{ResourceHandler}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}},
         \code{\link{ToLowerCasePipe}}
}
\section{Super class}{
\code{\link[bdpar:GenericPipe]{bdpar::GenericPipe}} -> \code{InterjectionPipe}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-InterjectionPipe-new}{\code{InterjectionPipe$new()}}
\item \href{#method-InterjectionPipe-pipe}{\code{InterjectionPipe$pipe()}}
\item \href{#method-InterjectionPipe-findInterjection}{\code{InterjectionPipe$findInterjection()}}
\item \href{#method-InterjectionPipe-removeInterjection}{\code{InterjectionPipe$removeInterjection()}}
\item \href{#method-InterjectionPipe-getPropertyLanguageName}{\code{InterjectionPipe$getPropertyLanguageName()}}
\item \href{#method-InterjectionPipe-getResourcesInterjectionsPath}{\code{InterjectionPipe$getResourcesInterjectionsPath()}}
\item \href{#method-InterjectionPipe-setResourcesInterjectionsPath}{\code{InterjectionPipe$setResourcesInterjectionsPath()}}
\item \href{#method-InterjectionPipe-clone}{\code{InterjectionPipe$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getAlwaysBeforeDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getAlwaysBeforeDeps'><code>bdpar::GenericPipe$getAlwaysBeforeDeps()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getNotAfterDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getNotAfterDeps'><code>bdpar::GenericPipe$getNotAfterDeps()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getPropertyName"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getPropertyName'><code>bdpar::GenericPipe$getPropertyName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="hash"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-hash'><code>bdpar::GenericPipe$hash()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setAlwaysBeforeDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setAlwaysBeforeDeps'><code>bdpar::GenericPipe$setAlwaysBeforeDeps()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setNotAfterDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setNotAfterDeps'><code>bdpar::GenericPipe$setNotAfterDeps()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setPropertyName"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setPropertyName'><code>bdpar::GenericPipe$setPropertyName()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InterjectionPipe-new"></a>}}
\if{latex}{\out{\hypertarget{method-InterjectionPipe-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{InterjectionPipe}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterjectionPipe$new(
  propertyName = "interjection",
  propertyLanguageName = "language",
  alwaysBeforeDeps = list("GuessLanguagePipe"),
  notAfterDeps = list(),
  removeInterjections = TRUE,
  resourcesInterjectionsPath = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{propertyName}}{A \code{\link{character}} value. Name of the property
associated with the \code{\link{GenericPipe}}.}

\item{\code{propertyLanguageName}}{A \code{\link{character}} value. Name of the
language property.}

\item{\code{alwaysBeforeDeps}}{A \code{\link{list}} value. The dependencies
alwaysBefore (\code{\link{GenericPipe}s} that must be executed before
this one).}

\item{\code{notAfterDeps}}{A \code{\link{list}} value. The dependencies
notAfter (\code{\link{GenericPipe}s} that cannot be executed after
this one).}

\item{\code{removeInterjections}}{A \code{\link{logical}} value. Indicates if
the interjections are removed or not.}

\item{\code{resourcesInterjectionsPath}}{A \code{\link{character}} value. Path
of resource files (in json format) containing the interjections.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InterjectionPipe-pipe"></a>}}
\if{latex}{\out{\hypertarget{method-InterjectionPipe-pipe}{}}}
\subsection{Method \code{pipe()}}{
Preprocesses the \code{\link{Instance}} to obtain/remove
the interjections. The interjections found in the data are added to the
list of properties of the \code{\link{Instance}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterjectionPipe$pipe(instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{A \code{\link{Instance}} value. The \code{\link{Instance}}
to preprocess.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link{Instance}} with the modifications that have
occurred in the pipe.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InterjectionPipe-findInterjection"></a>}}
\if{latex}{\out{\hypertarget{method-InterjectionPipe-findInterjection}{}}}
\subsection{Method \code{findInterjection()}}{
Checks if the interjection is in the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterjectionPipe$findInterjection(data, interjection)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A \code{\link{character}} value. The text where interjection
will be searched.}

\item{\code{interjection}}{A \code{\link{character}} value. Indicates the
interjection to find.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{logical}} value depending on whether the
interjection is in the data.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InterjectionPipe-removeInterjection"></a>}}
\if{latex}{\out{\hypertarget{method-InterjectionPipe-removeInterjection}{}}}
\subsection{Method \code{removeInterjection()}}{
Removes the \emph{interjection} in the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterjectionPipe$removeInterjection(interjection, data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{interjection}}{A \code{\link{character}} value. Indicates the
interjection to remove.}

\item{\code{data}}{A \code{\link{character}} value. The text where interjection
will be removed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The data with the interjections removed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InterjectionPipe-getPropertyLanguageName"></a>}}
\if{latex}{\out{\hypertarget{method-InterjectionPipe-getPropertyLanguageName}{}}}
\subsection{Method \code{getPropertyLanguageName()}}{
Gets the name of property language.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterjectionPipe$getPropertyLanguageName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of name of property language.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InterjectionPipe-getResourcesInterjectionsPath"></a>}}
\if{latex}{\out{\hypertarget{method-InterjectionPipe-getResourcesInterjectionsPath}{}}}
\subsection{Method \code{getResourcesInterjectionsPath()}}{
Gets the path of interjections resources.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterjectionPipe$getResourcesInterjectionsPath()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of path of interjections resources.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InterjectionPipe-setResourcesInterjectionsPath"></a>}}
\if{latex}{\out{\hypertarget{method-InterjectionPipe-setResourcesInterjectionsPath}{}}}
\subsection{Method \code{setResourcesInterjectionsPath()}}{
Sets the path of interjections resources.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterjectionPipe$setResourcesInterjectionsPath(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A \code{\link{character}} value. The new value of the path of
interjections resources.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InterjectionPipe-clone"></a>}}
\if{latex}{\out{\hypertarget{method-InterjectionPipe-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterjectionPipe$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
