% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbbreviationPipe.R
\name{AbbreviationPipe}
\alias{AbbreviationPipe}
\title{Class to find and/or replace the abbreviations on the data field of an Instance}
\description{
\code{\link{AbbreviationPipe}} class is responsible for detecting
the existing abbreviations in the \strong{data} field of each \code{\link{Instance}}.
Identified abbreviations are stored inside the \strong{abbreviation} field of
\code{\link{Instance}} class. Moreover if needed, is able to perform inline
abbreviations replacement.
}
\section{Details}{

\code{\link{AbbreviationPipe}} class requires the resource files (in json format)
containing the correspondence between abbreviations and meaning. To this end,
the language of the text indicated in the \emph{propertyLanguageName} should
be contained in the resource file name (ie. abbrev.xxx.json where xxx is the
value defined in the \emph{propertyLanguageName} ). The location of the
resources should be defined in the \strong{"resources.abbreviations.path"}
field of \emph{\link{bdpar.Options}} variable.
}

\section{Note}{

\code{\link{AbbreviationPipe}} will automatically invalidate the
\code{\link{Instance}} whenever the obtained data is empty.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\seealso{
\code{\link{bdpar.Options}}, \code{\link{ContractionPipe}},
         \code{\link{File2Pipe}}, \code{\link{FindEmojiPipe}},
         \code{\link{FindEmoticonPipe}}, \code{\link{FindHashtagPipe}},
         \code{\link{FindUrlPipe}}, \code{\link{FindUserNamePipe}},
         \code{\link{GuessDatePipe}}, \code{\link{GuessLanguagePipe}},
         \code{\link{Instance}}, \code{\link{InterjectionPipe}},
         \code{\link{MeasureLengthPipe}}, \code{\link{GenericPipe}},
         \code{\link{ResourceHandler}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}},
         \code{\link{ToLowerCasePipe}}
}
\section{Super class}{
\code{\link[bdpar:GenericPipe]{bdpar::GenericPipe}} -> \code{AbbreviationPipe}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AbbreviationPipe-new}{\code{AbbreviationPipe$new()}}
\item \href{#method-AbbreviationPipe-pipe}{\code{AbbreviationPipe$pipe()}}
\item \href{#method-AbbreviationPipe-findAbbreviation}{\code{AbbreviationPipe$findAbbreviation()}}
\item \href{#method-AbbreviationPipe-replaceAbbreviation}{\code{AbbreviationPipe$replaceAbbreviation()}}
\item \href{#method-AbbreviationPipe-getPropertyLanguageName}{\code{AbbreviationPipe$getPropertyLanguageName()}}
\item \href{#method-AbbreviationPipe-getResourcesAbbreviationsPath}{\code{AbbreviationPipe$getResourcesAbbreviationsPath()}}
\item \href{#method-AbbreviationPipe-setResourcesAbbreviationsPath}{\code{AbbreviationPipe$setResourcesAbbreviationsPath()}}
\item \href{#method-AbbreviationPipe-clone}{\code{AbbreviationPipe$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getAlwaysBeforeDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getAlwaysBeforeDeps'><code>bdpar::GenericPipe$getAlwaysBeforeDeps()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getNotAfterDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getNotAfterDeps'><code>bdpar::GenericPipe$getNotAfterDeps()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getPropertyName"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getPropertyName'><code>bdpar::GenericPipe$getPropertyName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="hash"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-hash'><code>bdpar::GenericPipe$hash()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setAlwaysBeforeDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setAlwaysBeforeDeps'><code>bdpar::GenericPipe$setAlwaysBeforeDeps()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setNotAfterDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setNotAfterDeps'><code>bdpar::GenericPipe$setNotAfterDeps()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setPropertyName"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setPropertyName'><code>bdpar::GenericPipe$setPropertyName()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbbreviationPipe-new"></a>}}
\if{latex}{\out{\hypertarget{method-AbbreviationPipe-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{AbbreviationPipe}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbbreviationPipe$new(
  propertyName = "abbreviation",
  propertyLanguageName = "language",
  alwaysBeforeDeps = list("GuessLanguagePipe"),
  notAfterDeps = list(),
  replaceAbbreviations = TRUE,
  resourcesAbbreviationsPath = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{propertyName}}{A \code{\link{character}} value. Name of the property
associated with the \code{\link{GenericPipe}}.}

\item{\code{propertyLanguageName}}{A \code{\link{character}} value. Name of the
language property.}

\item{\code{alwaysBeforeDeps}}{A \code{\link{list}} value. The dependencies
alwaysBefore (\code{\link{GenericPipe}s} that must be executed before
this one).}

\item{\code{notAfterDeps}}{A \code{\link{list}} value. The dependencies
notAfter (\code{\link{GenericPipe}s} that cannot be executed after
this one).}

\item{\code{replaceAbbreviations}}{A \code{\link{logical}} value. Indicates if
the abbreviations are replaced or not.}

\item{\code{resourcesAbbreviationsPath}}{A \code{\link{character}} value. Path
of resource files (in json format) containing the correspondence between
abbreviations and meaning.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbbreviationPipe-pipe"></a>}}
\if{latex}{\out{\hypertarget{method-AbbreviationPipe-pipe}{}}}
\subsection{Method \code{pipe()}}{
Preprocesses the \code{\link{Instance}} to obtain/replace
the abbreviations. The abbreviations found in the data are added to the
list of properties of the \code{\link{Instance}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbbreviationPipe$pipe(instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{A \code{\link{Instance}} value. The \code{\link{Instance}}
to preprocess.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link{Instance}} with the modifications that have
occurred in the pipe.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbbreviationPipe-findAbbreviation"></a>}}
\if{latex}{\out{\hypertarget{method-AbbreviationPipe-findAbbreviation}{}}}
\subsection{Method \code{findAbbreviation()}}{
Checks if the abbreviation is in the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbbreviationPipe$findAbbreviation(data, abbreviation)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A \code{\link{character}} value. The text where abbreviation
will be searched.}

\item{\code{abbreviation}}{A \code{\link{character}} value. Indicates the
abbreviation to find.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{logical}} value depending on whether the
abbreviation is in the data.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbbreviationPipe-replaceAbbreviation"></a>}}
\if{latex}{\out{\hypertarget{method-AbbreviationPipe-replaceAbbreviation}{}}}
\subsection{Method \code{replaceAbbreviation()}}{
Replaces the \emph{abbreviation} in the data for the
\emph{extendedAbbreviation}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbbreviationPipe$replaceAbbreviation(abbreviation, extendedAbbreviation, data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{abbreviation}}{A \code{\link{character}} value. Indicates the
abbreviation to replace.}

\item{\code{extendedAbbreviation}}{A \code{\link{character}} value. Indicates the
string to replace for the abbreviations found.}

\item{\code{data}}{A \code{\link{character}} value. The text where abbreviation
will be replaced.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The data with the abbreviations replaced.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbbreviationPipe-getPropertyLanguageName"></a>}}
\if{latex}{\out{\hypertarget{method-AbbreviationPipe-getPropertyLanguageName}{}}}
\subsection{Method \code{getPropertyLanguageName()}}{
Gets the name of property language.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbbreviationPipe$getPropertyLanguageName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of name of property language.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbbreviationPipe-getResourcesAbbreviationsPath"></a>}}
\if{latex}{\out{\hypertarget{method-AbbreviationPipe-getResourcesAbbreviationsPath}{}}}
\subsection{Method \code{getResourcesAbbreviationsPath()}}{
Gets the path of abbreviations resources.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbbreviationPipe$getResourcesAbbreviationsPath()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of path of abbreviations resources.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbbreviationPipe-setResourcesAbbreviationsPath"></a>}}
\if{latex}{\out{\hypertarget{method-AbbreviationPipe-setResourcesAbbreviationsPath}{}}}
\subsection{Method \code{setResourcesAbbreviationsPath()}}{
Sets the path of abbreviations resources.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbbreviationPipe$setResourcesAbbreviationsPath(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A \code{\link{character}} value. The new value of the path of
abbreviations resources.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbbreviationPipe-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AbbreviationPipe-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbbreviationPipe$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
