% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DefaultPipeline.R
\docType{class}
\name{DefaultPipeline}
\alias{DefaultPipeline}
\title{Class implementing a default pipelining proccess.}
\usage{
DefaultPipeline
}
\description{
This \code{\link{DefaultPipeline}} class inherits from the
\code{\link{GenericPipeline}} class. Includes the \strong{execute} method which
provides a default pipelining implementation.
}
\section{Constructor}{

\code{DefaultPipeline$new()}
}

\section{Details}{

The default flow is:

\preformatted{
instance \%>|\%

  TargetAssigningPipe$new() \%>|\%

  StoreFileExtPipe$new() \%>|\%

  GuessDatePipe$new() \%>|\%

  File2Pipe$new() \%>|\%

  MeasureLengthPipe$new(propertyName = "length_before_cleaning_text") \%>|\%

  FindUserNamePipe$new() \%>|\%

  FindHashtagPipe$new() \%>|\%

  FindUrlPipe$new() \%>|\%

  FindEmoticonPipe$new() \%>|\%

  FindEmojiPipe$new() \%>|\%

  GuessLanguagePipe$new() \%>|\%

  ContractionPipe$new() \%>|\%

  AbbreviationPipe$new() \%>|\%

  SlangPipe$new() \%>|\%

  ToLowerCasePipe$new() \%>|\%

  InterjectionPipe$new() \%>|\%

  StopWordPipe$new() \%>|\%

  MeasureLengthPipe$new(propertyName = "length_after_cleaning_text") \%>|\%

  TeeCSVPipe$new()
}
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipeline}} and implements the
\code{execute} abstract function.
}

\section{Methods}{

\itemize{
\item{\bold{execute:}}{
function where is implemented the flow of the pipes.
\itemize{
\item{\emph{Usage:}}{
\code{execute(instance)}
}
\item{\emph{Value:}}{
the preprocessed \code{\link{Instance}}.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{instance:}}{
(\emph{Instance}) the \code{\link{Instance}} that is going to be processed.
}
}
}
}
}

\item{\bold{get:}}{
gets a list with containinig the set of pipes of the pipeline,
\itemize{
\item{\emph{Usage:}}{
\code{get()}
}
\item{\emph{Value:}}{
the set of pipes containing the pipeline.
}
}
}
}
}

\seealso{
\code{\link{Instance}}, \code{\link{DynamicPipeline}},
         \code{\link{GenericPipeline}}, \code{\link{GenericPipe}},
         \code{\link{\%>|\%}}
}
