% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcmmrm.R
\name{bcmmrm}
\alias{bcmmrm}
\title{Model Median Inference for Longitudinal Data in Randomized Clinical Trials.}
\usage{
bcmmrm(
  outcome,
  group,
  data,
  time = NULL,
  id = NULL,
  covv = NULL,
  cfactor = NULL,
  structure = "UN",
  conf.level = 0.95,
  lmdint = c(-3, 3),
  glabel = NULL,
  tlabel = NULL
)
}
\arguments{
\item{outcome}{a name of positive outcome (dependent) variable included in
\code{data}.}

\item{group}{a name of treatment group variable included in \code{data}.}

\item{data}{a data frame that may include \code{outcome}, \code{group},
\code{time}, \code{id}, and specified covariate variables.}

\item{time}{a name of time variable for repeated measurements included
in \code{data}. The default is \code{NULL}.}

\item{id}{a name of subject id variable for repeated measurements included
in \code{data}. The default is \code{NULL}.}

\item{covv}{a character vector with names of covariate variables included
in \code{data}. The default is \code{NULL}.}

\item{cfactor}{an integer vector including nominal variable indicators for
covariate variables. Nominal variable: \code{1}, continuous variable:
\code{0}. The default is \code{NULL}.}

\item{structure}{specify the covariance structure from \code{c("UN", "CS",
"AR(1)")}. The default is \code{"UN"}.}

\item{conf.level}{a numeric value of the confidence level for the
confidence intervals. The default is 0.95.}

\item{lmdint}{a vector containing the end-points of the interval to be
searched for a transformation parameter. The default is \code{c(-3, 3)}.}

\item{glabel}{a vector of length number of treatment groups containing
the labels of \code{group} variable. The default is \code{NULL} and the
levels of \code{group} variable in \code{data} are used.}

\item{tlabel}{a vector of length number of repeated measures containing
the labels of \code{time} variable. The default is \code{NULL} and the
levels of \code{time} variable in \code{data} are used.}
}
\value{
an object of class "\code{bcmmrm}" representing the results of model
  median inference based on the Box-Cox transformed MMRM model.
  Generic functions such as \code{print}, \code{plot}, and \code{summary}
  have methods to show the results of the fit. See \code{\link{bcmmrmObject}}
  for the components of the fit.
}
\description{
\code{bcmmrm} provides inference results for the model median differences
between treatment groups proposed by Maruo et al. (2017), which focuses on
continuous and positive longitudinally observed outcomes and a situation
where the efficacy of some treatments is compared based on a randomized,
parallel group clinical trial. If \code{time} and \code{id} are not
specified, inference results reduce to the results for the context of
linear regression model provided by Maruo et al. (2015).
}
\note{
If baseline observation for the outcome variable is available, Box-Cox
  transformed baseline should be included as a covariate for accuracy of
  estimation.\cr Although this function can be applied to non-randomized
  trial data, performances of the above approach have not evaluated in
  context of non-randomized trials.
}
\examples{
data(aidscd4)

# covariate: Box-Cox transformed baseline (continuous) and sex (nominal),
# covariance structure: AR(1) structure
# *Note: The UN structure is preferred although the AR(1)
#        structure is used in this example to reduce calculation time

# Box-Cox transformation for the baseline
aidscd4$cd4.bl.tr <- bct.v(aidscd4$cd4.bl)$transformed

# Median inference for each group and week
bcmmrm(outcome = cd4, group = treatment, data = aidscd4, time = weekc,
       id = id, covv = c("cd4.bl.tr", "sex"), cfactor = c(0, 1),
       structure = "AR(1)", glabel = c("Zid/Did", "Zid+Zal", "Zid+Did",
       "Zid+Did+Nev"))

}
\references{
\itemize{
  \item Maruo, K., Isogawa, N., Gosho, M. (2015). Inference of median
        difference based on the Box-Cox model in randomized clinical trials.
        \emph{Statistics in Medicine}, 34, 1634-1644,
        \url{https://doi.org/10.1002/sim.6408}.\cr
  \item Maruo, K., Yamaguchi, Y., Noma, H., Gosho, M. (2017). Interpretable
        inference on the mixed effect model with the Box-Cox transformation.
        \emph{Statistics in Medicine}, 36, 2420-2434,
        \url{https://doi.org/10.1002/sim.7279}.
}
}
\seealso{
\code{\link{bcmarg}}, \code{\link{bcmmrmObject}}
}
