% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_poly_attribute}
\alias{get_poly_attribute}
\title{Get or calculate the attribute of a list-column containing nested dataframes.}
\usage{
get_poly_attribute(x, col, fun, ...)
}
\arguments{
\item{x}{the list-column in the (SpatialPolygons)DataFrame that contains nested data.frames}

\item{col}{the column in the nested data frames from which to retrieve/calculate attributes}

\item{fun}{function to determine the resulting single attribute from overlapping polygons}

\item{...}{other parameters passed on to \code{fun}}
}
\value{
An atomic vector of the same length as x
}
\description{
For example, \code{self_union} produces a \code{SpatialPolygonsDataFrame}
that has a column called \code{union_df}, which contains a \code{data.frame}
for each polygon with the attributes from the constituent polygons.
}
\examples{
\dontrun{
if (require(sp)) {
  p1 <- Polygon(cbind(c(2,4,4,1,2),c(2,3,5,4,2)))
  p2 <- Polygon(cbind(c(5,4,3,2,5),c(2,3,3,2,2)))
  ps1 <- Polygons(list(p1), "s1")
  ps2 <- Polygons(list(p2), "s2")
  spp <- SpatialPolygons(list(ps1,ps2), 1:2)
  df <- data.frame(a = c(1, 2), b = c("foo", "bar"),
                   c = factor(c("high", "low"), ordered = TRUE,
                              levels = c("low", "high")),
                   stringsAsFactors = FALSE)
  spdf <- SpatialPolygonsDataFrame(spp, df, match.ID = FALSE)
  plot(spdf, col = c(rgb(1, 0, 0,0.5), rgb(0, 0, 1,0.5)))
  unioned_spdf <- self_union(spdf)
  get_poly_attribute(unioned_spdf$union_df, "a", sum)
  get_poly_attribute(unioned_spdf$union_df, "c", max)
}
}
}
