% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-to-file.R
\name{model_to_file}
\alias{model_to_file}
\title{Save model to text file}
\usage{
model_to_file(model = NULL, filename = NULL, heavy_tailed = FALSE)
}
\arguments{
\item{model}{Model to be saved. Options are "slope", "firstdiff", "gam", "gamye"}

\item{filename}{File name to create on disk.}

\item{heavy_tailed}{Logical indicating whether the extra-Poisson error distribution should be modeled as a t-distribution, with heavier tails than the standard normal distribution. Default is currently FALSE, but recent results suggest users should strongly consider setting this to TRUE, even though it requires much longer convergence times}
}
\value{
None
}
\description{
\code{model_to_file} allows you to save any of the preloaded hierarchical
  Bayesian models to a text file.
}
\examples{

# Save the Slope model to a file called "slope.txt" in temp directory
model_to_file(model = "slope",
              filename = file.path(tempdir(), "slope.txt"))

# Save the First Difference model to a file called "fd.txt" in temp directory
model_to_file(model = "firstdiff",
              filename = file.path(tempdir(), "fd.txt"))

# Save the GAM model to a file called "gam.txt" in temp directory
model_to_file(model = "gam",
              filename = file.path(tempdir(), "gam.txt"))

# Save the GAM year effects model to a file called "gamye.txt" in temp directory
model_to_file(model = "gamye",
              filename = file.path(tempdir(), "gamye.txt"))

}
