% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayesian_Bricks.r
\name{sufficientStatistics_Weighted}
\alias{sufficientStatistics_Weighted}
\title{Get weighted sample sufficient statistics}
\usage{
sufficientStatistics_Weighted(obj, ...)
}
\arguments{
\item{obj}{A "BayesianBrick" object used to select a method.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An object of corresponding sufficient statistics class, such as "ssGaussian"
}
\description{
This is a generic function that will generate the weighted sufficient statistics of a given "BayesianBrick" object. That is, for the model structure: \cr
     theta|gamma ~ H(gamma) \cr
     X|theta ~ F(theta) \cr
get the weighted sufficient statistics T(X)
}
\examples{
\donttest{
x <- rGaussian(10,mu = 1,Sigma = 1)
w <- runif(10)
obj <- GaussianNIW()                    #an GaussianNIW object
sufficientStatistics_Weighted(obj=obj,x=x,w=w)
}
}
\seealso{
\code{\link{sufficientStatistics_Weighted.GaussianNIW}} for Gaussian-NIW conjugate structure, \code{\link{sufficientStatistics_Weighted.GaussianNIG}} for Gaussian-NIG conjugate structure, \code{\link{sufficientStatistics_Weighted.CatDirichlet}} for Categorical-Dirichlet conjugate structure, \code{\link{sufficientStatistics_Weighted.CatDP}} for Categorical-DP conjugate structure ...
}
