% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{MAP.GaussianNIW}
\alias{MAP.GaussianNIW}
\title{Maximum A Posteriori(MAP) estimate of a "GaussianNIW" object}
\usage{
\method{MAP}{GaussianNIW}(obj, ...)
}
\arguments{
\item{obj}{A "GaussianNIW" object.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A named list, the MAP estimate of "theta".
}
\description{
Generate the MAP estimate of "theta" in following Gaussian-NIW structure: \cr
     theta|gamma ~ NIW(gamma) \cr
     x|theta ~ Gaussian(theta) \cr
where theta = (mu,Sigma) is the Gaussian parameter, gamma = (m,k,v,S) is the Normal-Inverse-Wishart(NIW) parameter. \cr
The model structure and prior parameters are stored in a "GaussianNIW" object. \cr
MAP is theta_MAP = argmax_theta p(theta|gamma,x).
}
\examples{
## update the piror with new observations then calculate the MAP estimate
x <- rGaussian(1000,mu = c(1,1),Sigma = matrix(c(1,0.5,0.5,3),2,2))
w <- runif(1000)
obj <- GaussianNIW(gamma=list(m=c(0,0),k=1,v=2,S=diag(2)))
ss <- sufficientStatistics_Weighted(obj = obj,x=x,w=w,foreach = TRUE)
for(i in 1L:length(ss)) posterior(obj = obj,ss=ss[[i]])
MAP(obj)
}
\references{
Murphy, Kevin P. "Conjugate Bayesian analysis of the Gaussian distribution." def 1.22 (2007): 16.

Gelman, Andrew, et al. "Bayesian Data Analysis Chapman & Hall." CRC Texts in Statistical Science (2004).
}
\seealso{
\code{\link{GaussianNIW}}
}
