% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_Bes.R
\name{dbessel}
\alias{dbessel}
\title{dbessel}
\usage{
dbessel(z, mu, phi)
}
\arguments{
\item{z}{scalar (0 < z < 1) for which the p.d.f. is to be evaluated.}

\item{mu}{scalar representing the mean parameter.}

\item{phi}{scalar representing the precision parameter.}
}
\value{
scalar expressing the value of the density at z.
}
\description{
Function to calculate the probability density of the bessel distribution.
}
\examples{
z = seq(0.01, 0.99, 0.01); np = length(z);
density = rep(0, np)
for(i in 1:np){ density[i] = dbessel(z[i], 0.5, 1) }
plot(z, density, type = "l", lwd = 2, cex.lab = 2, cex.axis = 2)
}
\seealso{
\code{\link{simdata_bes}}, \code{\link{dbbtest}}, \code{\link{simdata_bet}}
}
