% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ContextOptimization.R
\name{ContextOptimization}
\alias{ContextOptimization}
\title{Optimization Context}
\description{
The \link{ContextOptimization} allows \link[mlr3misc:Callback]{mlr3misc::Callback}s to access and modify data while optimization.
See section on active bindings for a list of modifiable objects.
See \code{\link[=callback_optimization]{callback_optimization()}} for a list of stages which access \link{ContextOptimization}.
}
\section{Super class}{
\code{\link[mlr3misc:Context]{mlr3misc::Context}} -> \code{ContextOptimization}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{instance}}{(\link{OptimInstance}).}

\item{\code{optimizer}}{(\link{Optimizer}).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{xdt}}{(\link[data.table:data.table]{data.table::data.table})\cr
The points of the latest batch.
Contains the values in the search space i.e. transformations are not yet applied.}

\item{\code{result}}{(\link[data.table:data.table]{data.table::data.table})\cr
The result of the optimization.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ContextOptimization-new}{\code{ContextOptimization$new()}}
\item \href{#method-ContextOptimization-clone}{\code{ContextOptimization$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Context" data-id="format"><a href='../../mlr3misc/html/Context.html#method-Context-format'><code>mlr3misc::Context$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Context" data-id="print"><a href='../../mlr3misc/html/Context.html#method-Context-print'><code>mlr3misc::Context$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContextOptimization-new"></a>}}
\if{latex}{\out{\hypertarget{method-ContextOptimization-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContextOptimization$new(instance, optimizer)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{(\link{OptimInstance}).}

\item{\code{optimizer}}{(\link{Optimizer}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContextOptimization-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ContextOptimization-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContextOptimization$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
