% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ridge_regression.R
\name{RidgeRegression}
\alias{RidgeRegression}
\alias{RidgeRegression.default}
\alias{RidgeRegression.Seurat}
\title{Perform ridge regression on scaled expression data}
\usage{
RidgeRegression(object, ...)

\method{RidgeRegression}{default}(
  object,
  latent_data,
  batch_key,
  confounder_key,
  lambda = 1,
  seed = 42,
  verbose = TRUE,
  ...
)

\method{RidgeRegression}{Seurat}(
  object,
  batch_key,
  confounder_key,
  assay = NULL,
  features = NULL,
  lambda = 1,
  run_pca = TRUE,
  npcs = 50,
  reduction.name = "pca",
  reduction.key = "PC_",
  replace = FALSE,
  seed = 42,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{latent_data}{Extra data to regress out, should be cells x latent data}

\item{batch_key}{Variables to regress out as technical effects. Must be 
included in column names of latent_data}

\item{confounder_key}{Variables to to retain as biological effects. Must be 
included in column names of latent_data}

\item{lambda}{A user supplied lambda sequence. pass to 
\code{\link[glmnet]{glmnet}}}

\item{seed}{Set a random seed. By default, sets the seed to 42. Setting NULL 
will not set a seed.}

\item{verbose}{Whether or not to print output to the console}

\item{assay}{Name of Assay ridge regression is being run on}

\item{features}{Features to compute ridge regression on. If features=NULL, 
ridge regression will be run using the variable features for the Assay.}

\item{run_pca}{Whether or not to run pca with regressed expression data 
(TRUE by default)}

\item{npcs}{Total Number of PCs to compute and store (50 by default)}

\item{reduction.name}{Dimensional reduction name (pca by default)}

\item{reduction.key}{Dimensional reduction key, specifies the string before 
the number for the dimension names (PC by default)}

\item{replace}{Whether or not to replace original scale.data with regressed 
expression data (TRUE by default)}
}
\value{
Returns a Seurat object.
}
\description{
Perform ridge regression on scaled expression data, accepting both technical 
and biological categorical variables. The effect of the technical variables 
is removed while the effect of the biological variables is retained. This is 
a preprocessing step that can aid BBKNN integration.
}
\examples{
data("panc8_small")
panc8_small <- RidgeRegression(panc8_small, "tech", c("nCount_RNA"))

}
\references{
Park, Jong-Eun, et al. "A cell atlas of human thymic development 
defines T cell repertoire formation." Science 367.6480 (2020): eaay3224.
}
