% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbk.R
\name{bbk_metadata}
\alias{bbk_metadata}
\title{Returns the available Bundesbank metadata}
\source{
\url{https://www.bundesbank.de/en/statistics/time-series-databases/help-for-sdmx-web-service/web-service-interface-metadata}
}
\usage{
bbk_metadata(type, id = NULL, lang = c("en", "de"))
}
\arguments{
\item{type}{\code{character(1)} the type of metadata to query. One of:
\code{"datastructure"}, \code{"dataflow"}, \code{"codelist"}, or \code{"concept"}.}

\item{id}{\code{character(1)} id to query. Default \code{NULL}.}

\item{lang}{\code{character(1)} language to query, either \code{"en"} or \code{"de"}.
Default \code{"en"}.}
}
\value{
A \code{data.frame()} with the queried metadata.
The columns are:
\item{id}{The id of the metadata}
\item{name}{The name of the metadata}
}
\description{
Retrieval of the metadata stored in the Bundesbank's time series database.
Access via the SDMX Web Service API of the Bundesbank.
}
\examples{
\donttest{
bbk_metadata("datastructure")
bbk_metadata("dataflow", "BBSIS")
bbk_metadata("codelist", "CL_BBK_ACIP_ASSET_LIABILITY")
bbk_metadata("concept", "CS_BBK_BSPL")
}
}
\seealso{
Other metadata: 
\code{\link{ecb_metadata}()}
}
\concept{metadata}
