% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_beta_binomial.R
\name{summarize_beta_binomial}
\alias{summarize_beta_binomial}
\title{Summarize a Beta-Binomial Bayesian model}
\usage{
summarize_beta_binomial(alpha, beta, y = NULL, n = NULL)
}
\arguments{
\item{alpha, beta}{positive shape parameters of the prior Beta model}

\item{y}{number of successes}

\item{n}{number of trials}
}
\value{
a summary table
}
\description{
Consider a Beta-Binomial Bayesian model for parameter \eqn{\pi} with 
a Beta(alpha, beta) prior on \eqn{\pi} and Binomial likelihood with n trials
and y successes. Given information on the prior (alpha and data) and data (y and n),
this function summarizes the mean, mode, and variance of the 
prior and posterior Beta models of \eqn{\pi}.
}
\examples{
summarize_beta_binomial(alpha = 1, beta = 15, y = 25, n = 50)
}
