% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesplot-package.R
\docType{package}
\name{bayesplot-package}
\alias{bayesplot-package}
\alias{bayesplot}
\title{\strong{bayesplot}: Plotting for Bayesian Models}
\description{
\if{html}{
   \figure{stanlogo.png}{options: width="50px" alt="mc-stan.org"}
}
\emph{Stan Development Team}

The \strong{bayesplot} package provides a variety of \strong{ggplot2}-based
plotting functions for use after fitting Bayesian models (typically, though
not exclusively, via Markov chain Monte Carlo). The package is designed not
only to provide convenient functionality for users, but also a common set of
functions that can be easily used by developers working on a variety of
packages for Bayesian modeling, particularly (but not necessarily) packages
powered by \link[rstan:rstan-package]{rstan} (the \R interface to Stan).
Examples of packages that will soon (or already are) using \strong{bayesplot} are
\strong{rstan} itself, as well as the \strong{rstan}-dependent \strong{rstanarm} and
\strong{brms} packages for applied regression modeling.
}
\section{Plotting functionality}{

\if{html}{
   \figure{bayesplot1.png}{options: width="30\%" alt="mcmc_areas"}
   \figure{bayesplot2.png}{options: width="30\%" alt="ppc_hist"}
   \figure{bayesplot3.png}{options: width="30\%" alt="ppc_dens_overlay"}
 }

The plotting functions in \strong{bayesplot} are organized into several modules:
\itemize{
\item \link[=MCMC-overview]{MCMC}: Visualizations of Markov chain
Monte Carlo (MCMC) simulations generated by \emph{any} MCMC algorithm
as well as diagnostics. There are also additional functions specifically
for use with models fit using the \link[=NUTS]{No-U-Turn Sampler (NUTS)}.
\item \link[=PPC-overview]{PPC}: Graphical prior and posterior predictive
checks (PPCs).
}

In future releases modules will be added specifically for
forecasting/out-of-sample prediction and other inference-related tasks.
}

\section{Resources}{

\itemize{
\item \strong{Online documentation and vignettes}: Visit the \strong{bayesplot} website at
\url{https://mc-stan.org/bayesplot}
\item \strong{Bug reports and feature requests}: If you would like to request a new
feature or if you have noticed a bug that needs to be fixed please let us
know at the \strong{bayesplot} issue tracker at
\url{https://github.com/stan-dev/bayesplot/issues/}
\item \strong{General questions and help}:
To ask a question about \strong{bayesplot} on the Stan Forums forum please visit
\url{https://discourse.mc-stan.org}.
}
}

\examples{
# A few quick examples (all of the functions have many examples
# on their individual help pages)

# MCMC plots
x <- example_mcmc_draws(params = 5)
mcmc_intervals(x, prob = 0.5)
mcmc_intervals(x, regex_pars = "beta")

color_scheme_set("purple")
mcmc_areas(x, regex_pars = "beta", prob = 0.8)

color_scheme_set("mix-blue-red")
mcmc_trace(x, pars = c("alpha", "sigma"),
           facet_args = list(nrow = 2))

color_scheme_set("brightblue")
mcmc_scatter(x, pars = c("beta[1]", "sigma"),
             transformations = list(sigma = "log"))


# Graphical PPCs
y <- example_y_data()
yrep <- example_yrep_draws()
ppc_dens_overlay(y, yrep[1:50, ])
\donttest{
color_scheme_set("pink")
ppc_stat(y, yrep, stat = "median") + grid_lines()
ppc_hist(y, yrep[1:8, ])
}

}
\references{
Gabry, J. , Simpson, D. , Vehtari, A. , Betancourt, M. and
Gelman, A. (2019), Visualization in Bayesian workflow.
\emph{J. R. Stat. Soc. A}, 182: 389-402. doi:10.1111/rssa.12378.
(\href{https://rss.onlinelibrary.wiley.com/doi/full/10.1111/rssa.12378}{journal version},
\href{https://arxiv.org/abs/1709.01449}{arXiv preprint},
\href{https://github.com/jgabry/bayes-vis-paper}{code on GitHub})
}
\seealso{
\code{\link[=theme_default]{theme_default()}} for the default ggplot theme used by
\strong{bayesplot} and \code{\link[=bayesplot_theme_set]{bayesplot_theme_set()}} to change it.

\link{bayesplot-colors} to set or view the color scheme used
for plotting.

\code{\link[ggplot2:ggsave]{ggplot2::ggsave()}} for saving plots.
}
