% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc-scatterplots.R
\name{MCMC-scatterplots}
\alias{MCMC-scatterplots}
\alias{mcmc_scatter}
\title{Scatterplots of MCMC draws}
\usage{
mcmc_scatter(x, pars = character(), regex_pars = character(),
  transformations = list(), ..., size = 2.5, alpha = 0.8)
}
\arguments{
\item{x}{A 3-D array, matrix, list of matrices, or data frame of MCMC draws.
The \link{MCMC-overview} page provides details on how to specify each these
allowed inputs.}

\item{pars}{An optional character vector of parameter names. (\strong{Note}:
for \code{mcmc_scatter} only two parameters can be selected.)}

\item{regex_pars}{An optional \link[=grep]{regular expression} to use for
parameter selection. Can be specified instead of \code{pars} or in addition
to \code{pars}.}

\item{transformations}{An optional named list specifying transformations to
apply to parameters. The name of each list element should be a parameter
name and the content of each list element should be a function (or any item
to match as a function via \code{\link{match.fun}}, e.g. a string naming a
function). If a function in the list of transformations is specified by its
name as a string (e.g. \code{"log"}), then it can be used to construct a
new parameter label for the appropriate parameter (e.g.
\code{"log(sigma)"}). If a function itself is specified (e.g. \code{log} or
\code{function(x) log(x)}) then \code{"t"} is used in the new parameter
label to indicate that the parameter is transformed (e.g.
\code{"t(sigma)"}).}

\item{...}{Currently ignored.}

\item{size, alpha}{Passed to \code{\link[ggplot2]{geom_point}}.}
}
\value{
A ggplot object that can be further customized using the
  \pkg{ggplot2} package.
}
\description{
Scatterplots of MCMC draws. See the \strong{Plot Descriptions} section,
below, for details.
}
\section{Plot Descriptions}{

\describe{
  \item{\code{mcmc_scatter}}{
   Bivariate scatterplot of posterior draws (for two parameters).
  }
  \item{\code{mcmc_pairs}}{
  Coming soon.
  }
}
}
\examples{
# some parameter draws to use for demonstration
x <- example_mcmc_draws(params = 6)
dimnames(x)

# scatterplot of alpha vs log(sigma)
color_scheme_set("teal")
p <- mcmc_scatter(x, pars = c("alpha", "sigma"),
                  trans = list(sigma = "log"),
                  alpha = 0.5)
p + ggplot2::labs(caption = "A fascinating caption")

# add ellipse
p + ggplot2::stat_ellipse(level = 0.9, color = "gray20", size = 1)

# add contour
color_scheme_set("red")
p2 <- mcmc_scatter(x, pars = c("alpha", "sigma"))
p2 + ggplot2::stat_density_2d(color = "black")

# can also add lines/smooths
color_scheme_set("pink")
(p3 <- mcmc_scatter(x, pars = c("alpha", "beta[3]"), alpha = 0.5, size = 3))
p3 + ggplot2::geom_smooth(method = "lm", se = FALSE, color = "gray20")



}
\seealso{
Other MCMC: \code{\link{MCMC-combos}},
  \code{\link{MCMC-diagnostics}},
  \code{\link{MCMC-distributions}},
  \code{\link{MCMC-intervals}}, \code{\link{MCMC-nuts}},
  \code{\link{MCMC-overview}}, \code{\link{MCMC-recover}},
  \code{\link{MCMC-traces}}
}

