% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.R
\name{vcov}
\alias{vcov}
\alias{vcov.aov_b}
\alias{vcov.lm_b}
\alias{vcov.glm_b}
\alias{vcov.np_glm_b}
\title{Calculate Posterior Variance-Covariance Matrix for a Bayesian Fitted Model Object}
\usage{
\method{vcov}{aov_b}(object, ...)

\method{vcov}{lm_b}(object, ...)

\method{vcov}{glm_b}(object, ...)

\method{vcov}{np_glm_b}(object, ...)
}
\arguments{
\item{object}{a fitted model object from \code{bayesics}.}

\item{...}{Passed to methods.}
}
\value{
A matrix of the covariance matrix for the regression coefficients.  If the posterior
is a multivariate t distribution (or consists of independent t's in the case of heteroscedastic
1-way ANOVA), the degrees of freedom are returned as the \code{df} attribute of the matrix.  Note
that for \code{lm_b} and \code{aov_b} objects, this function already takes into account the
uncertainty around the residual variance.
}
\description{
Returns the posterior covariance matrix of the main parameters of a fitted \code{bayesics} object
}
\examples{
\donttest{
set.seed(2025)
N = 500
test_data <-
  data.frame(x1 = rnorm(N),
             x2 = rnorm(N),
             x3 = letters[1:5])
test_data$outcome <-
  rnorm(N,-1 + test_data$x1 + 2 * (test_data$x3 \%in\% c("d","e")) )
fit1 <-
  lm_b(outcome ~ x1 + x2 + x3,
       data = test_data)
vcov(fit1)
}

}
