% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_test_b.R
\name{cor_test_b}
\alias{cor_test_b}
\alias{cor_test_b.default}
\alias{cor_test_b.formula}
\title{Test for Association/Correlation Between Paired Samples via Kendall's tau}
\usage{
cor_test_b(x, ...)

\method{cor_test_b}{default}(
  x,
  y,
  tau = 0,
  ROPE,
  prior = "centered",
  prior_shapes,
  CI_level = 0.95,
  plot = TRUE,
  ...
)

\method{cor_test_b}{formula}(
  formula,
  data,
  tau = 0,
  ROPE,
  prior = "centered",
  prior_shapes,
  CI_level = 0.95,
  plot = TRUE,
  ...
)
}
\arguments{
\item{x, y}{numeric vectors of data values. x and y must have the same length.}

\item{...}{optional arguments.}

\item{tau}{If provided, cor_test_b will return the posterior probability that
Kendall's tau is less than this value.}

\item{ROPE}{If a single number, ROPE will be \eqn{\tau\pm} ROPE. If a vector
of length 2, these will serve as the ROPE bounds. Defaults to \eqn{\pm}0.05.}

\item{prior}{Beta prior used on \eqn{phi} (see details).  Either "uniform'
(Beta(1,1)), "centered' (Beta(2,2)), "positive" (Beta(3.9,2), putting 80\% of
the prior mass above 0.5), or "negative" (Beta(2,3.9), putting 80\% of the
prior mass below 0.5).}

\item{prior_shapes}{Vector of length two, giving the shape parameters for
the beta distribution that will act as the prior on \eqn{\phi} (see details).}

\item{CI_level}{The posterior probability to be contained in the credible
interval.}

\item{plot}{logical. Should a plot be shown?}

\item{formula}{ADD description!}

\item{data}{ADD description!}
}
\value{
(returned invisible) A list with the following:
\itemize{
\item \code{posterior_mean}: posterior mean of Kendall's tau
\item \code{CI}: Credible interval bounds
\item \code{Pr_less_than_tau}: Posterior probability that Kendall's tau is less than provided reference \code{tau}
\item \code{Pr_in_ROPE}: Posterior probability that Kendall's tau is in the ROPE
\item \code{prob_plot}: Posterior and prior plot
\item \code{posterior_parameters}: The posterior for Kendall's tau is a location shift and scaled
beta distribution to fall over the range -1 to 1, i.e., \eqn{0.5 * (\tau + 1.0)} follows a
beta with shape parameters given by \code{posterior_parameters}.
\item \code{dfba_bivariate_concordance_object}: The underlying object from the DFBA package
}
}
\description{
Test for Association/Correlation Between Paired Samples via Kendall's tau
}
\details{
cor_test_b relies on the robust Kendall's tau, defined to be
\deqn{
 \tau := \frac{(\# \text{concordant pairs}) - (\# \text{discordant pairs})}{(\# \text{concordant pairs}) - (\# \text{discordant pairs})},
}
where a concordant pair is a pair of points such that if the rank of the x
values is higher for the first (second) point of the pair, so too the rank
of the y value is higher for the first (second) point of the pair.

The Bayesian approach of Chechile (2020) puts a Beta prior on \eqn{phi}, the
proportion of concordance, i.e.,
\deqn{
 \phi := \frac{(\# \text{concordant pairs})}{(\# \text{concordant pairs}) - (\# \text{discordant pairs})}.
}
The relationship between the two, then, is \eqn{\tau = 2\phi - 1}, or
equivalently \eqn{\phi = (\tau + 1)/2}.

For more information, see \link[DFBA]{dfba_bivariate_concordance}
and vignette("dfba_bivariate_concordance",package = "DFBA").
}
\examples{
\donttest{
# Generate data
set.seed(2025)
N = 50
x = rnorm(N)
y = x + 4 * rnorm(N)

# Test for non-zero correlation
cor_test_b(x,y)

# Input can be in the form of formula and data
cor_test_b(~ asdf + qwer,
           data = data.frame(asdf = x,
                             qwer = y))

# Other priors can be used, also.  See help for details.
cor_test_b(x,y,
           prior = "uniform")
cor_test_b(x,y,
           prior = "negative")
cor_test_b(x,y,
           prior = "positive")
cor_test_b(x,y,
           prior_shapes = c(10,10))
}


}
\references{
Chechile, R.A. (2020). Bayesian Statistics for Experimental Scientists: A General Introduction Using Distribution_Free Statistics. Cambridge: MIT Press.

Chechile, R.A., & Barch, D.H. (2021). A distribution-free, Bayesian goodness-of-fit method for assessing similar scientific prediction equations. Journal of Mathematical Psychology. https://doi.org/10.1016/j.jmp.2021.102638

Lindley, D. V., & Phillips, L. D. (1976). Inference for a Bernoulli process (a Bayesian view). The American Statistician, 30, 112-119.

Barch DH, Chechile RA (2023). DFBA: Distribution-Free Bayesian Analysis. doi:10.32614/CRAN.package.DFBA
}
