% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case_control_b.R
\name{case_control_b}
\alias{case_control_b}
\title{Case-Control Analysis}
\usage{
case_control_b(
  cases,
  controls,
  x,
  large_sample_approx,
  ROPE,
  prior_mean = 0,
  prior_sd = log(10)/1.96,
  plot = TRUE,
  CI_level = 0.95,
  seed = 1,
  mc_error = 0.005
)
}
\arguments{
\item{cases}{vector of length 2, giving the numbers at risk and not at risk,
respectively, for cases}

\item{controls}{vector of length 2, giving the numbers at risk and not at risk,
respectively, for controls}

\item{x}{2x2 contingency table.  The rows should depict the at risk status
(first row is at risk, second row is not at risk), and the columns should
depict the case control status (first column is case, second column is control).}

\item{large_sample_approx}{If all cell counts of \code{x} are not too low
(\eqn{\geq 5}) then use the approximation that the empirical log odds are
normally distributed.  (See details for more.)  If missing, this will be
set to \code{TRUE} iff all cell counts are greater than or equal to 5.}

\item{ROPE}{ROPE for odds ratio. Provide either a single value or a vector
of length two.  If the former, the ROPE will be taken as (1/ROPE,ROPE).
If the latter, these will be the bounds of the ROPE.}

\item{prior_mean}{numeric.  The prior mean on the log odds ratio}

\item{prior_sd}{numeric.  The prior sd on the log odds ratio. See details
for default values.}

\item{plot}{logical.  Should a plot be shown?}

\item{CI_level}{The posterior probability to be contained in the
credible interval.}

\item{seed}{integer.  Always set your seed!!! (ignored if \code{large_sample_approx = TRUE}.)}

\item{mc_error}{The relative monte carlo error of the quantiles of the CIs.
(ignored if \code{large_sample_approx = TRUE}.)}
}
\value{
(returned invisible) list including the following:
\itemize{
\item \code{data}: data
\item \code{posterior_mean}: posterior mean of the odds ratio (cases vs. controls)
\item \code{CI}: Credible interval
\item \code{Pr_oddsratio_in_ROPE}: Probability the odds ratio (cases vs. controls) is in the ROPE
\item \code{posterior_draws}: posterior draws of the odds ratio (cases vs. controls)
\item \code{or_plot}: odds ratio (cases vs. controls) posterior plot
}
}
\description{
Bayesian analysis of a case-control study (without covariates).
}
\details{
If \code{large_sample_approx = TRUE} (the default if left missing and all
cell counts are at least 5), then the likelihood is
\deqn{
 \log(\hat\omega) \sim N\left(\log(\omega),\frac{1}{n_{11}} + \frac{1}{n_{12}} + 
 \frac{1}{n_{21}} + \frac{1}{n_{22}} \right),
}
where \eqn{\omega} is the odds ratio, \eqn{\hat\omega} is the
empirical odds ratio, \eqn{n_{ij}}, \eqn{i,j = 1,2} are the cells of the
2x2 contingency table. The prior on \eqn{\log\omega} is
\deqn{
 \log\omega \sim N(a,b^2).
}

If the large sample approximation is not used, then inference is made on
the odds ratio by instead putting uniform priors on \eqn{\Pr(exposure|outcome)}.
}
\examples{
case_control_b(matrix(c(8,47,1,26),2,2))

case_control_b(c(8,47),
               c(1,26))



}
