% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/particle_filter-doc.R
\name{particle_filter_common_params}
\alias{particle_filter_common_params}
\title{Common Parameters for Particle Filters}
\arguments{
\item{y}{A numeric vector or matrix of observations. Each row represents an
observation at a time step. If observations are not equally spaced, use the
\code{obs_times} argument.}

\item{num_particles}{A positive integer specifying the number of particles.}

\item{init_fn}{A function to initialize the particles. Should take
`num_particles` and return a matrix or vector of initial states. Additional
model parameters can be passed via \code{...}.}

\item{transition_fn}{A function for propagating particles. Should take
`particles` and optionally `t`. Additional model parameters via \code{...}.}

\item{log_likelihood_fn}{A function that returns the log-likelihood for each
particle given the current observation, particles, and optionally `t`.
Additional parameters via \code{...}.}

\item{obs_times}{A numeric vector specifying observation time points. Must
match the number of rows in \code{y}, or defaults to \code{1:nrow(y)}.}

\item{resample_algorithm}{A character string specifying the filtering
resample algorithm:
\code{"SIS"} for no resampling, \code{"SISR"} for resampling at every time
step, or \code{"SISAR"} for adaptive resampling when ESS
drops below \code{threshold}. Using \code{"SISR"} or \code{"SISAR"} to
avoid weight degeneracy is recommedended. Default is \code{"SISAR"}.}

\item{resample_fn}{A string indicating the resampling method:
\code{"stratified"}, \code{"systematic"}, or \code{"multinomial"}.
Default is \code{"stratified"}.}

\item{threshold}{A numeric value specifying the ESS threshold for
\code{"SISAR"}. Defaults to \code{num_particles / 2}.}

\item{return_particles}{Logical; if \code{TRUE}, returns the full particle
and weight histories.}

\item{...}{Additional arguments passed to \code{init_fn},
\code{transition_fn}, and \code{log_likelihood_fn}.}
}
\description{
These parameters are shared by particle filter implementations such as the
bootstrap filter, auxiliary particle filter, and resample-move particle
filter.
}
\keyword{internal}
