% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testJob.R
\name{testJob}
\alias{testJob}
\title{Run Jobs Interactively}
\usage{
testJob(id, external = FALSE, reg = getDefaultRegistry())
}
\arguments{
\item{id}{[\code{integer(1)} or \code{data.table}]\cr
Single integer to specify the job or a \code{data.table} with column \code{job.id}
and exactly one row.}

\item{external}{[\code{logical(1)}]\cr
 Run the job in an external R session? If \code{TRUE}, starts a fresh R
 session on the local machine to execute the with \code{\link{execJob}}.
 You will not be able to use debug tools like \code{\link[base]{traceback}}
 or \code{\link[base]{browser}}.

 If \code{external} is set to \code{FALSE} (default) on the other hand,
 \code{testJob} will execute the job in the current R session and the usual
 debugging tools work. However, spotting missing variable declarations (as they
 are possibly resolved in the global environment) is impossible.
 Same holds for missing package dependency declarations.}

\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}
}
\value{
Returns the result of the job if successful.
}
\description{
Starts a single job on the local machine.
}
\examples{
tmp = makeRegistry(file.dir = NA, make.default = FALSE)
batchMap(function(x) if (x == 2) xxx else x, 1:2, reg = tmp)
testJob(1, reg = tmp)
\dontrun{
testJob(2, reg = tmp)
}
}
\seealso{
Other debug: \code{\link{getErrorMessages}},
  \code{\link{getStatus}}, \code{\link{grepLogs}},
  \code{\link{killJobs}}, \code{\link{resetJobs}},
  \code{\link{showLog}}
}
