% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Worker.R
\docType{class}
\name{Worker}
\alias{Worker}
\title{Create a Linux-Worker}
\format{An \code{\link{R6Class}} generator object}
\usage{
Worker
}
\value{
[\code{\link{Worker}}].
}
\description{
\code{\link[R6]{R6Class}} to create local and remote linux workers.
}
\section{Fields}{

\describe{
\item{\code{nodename}}{Host name. Set via constructor.}

\item{\code{ncpus}}{Number of VPUs of worker. Set via constructor and defaults to the number of CPUs of the machine.}

\item{\code{max.load}}{Maximum load average (of the last 5 min). Set via constructor and defaults to the number of CPUs of the machine.}

\item{\code{status}}{Status of the worker; one of \dQuote{unknown}, \dQuote{available}, \dQuote{max.cpus} and \dQuote{max.load}.}
}}
\section{Methods}{

\describe{
 \item{\code{new(nodename, ncpus, max.load)}}{Constructor.}
 \item{\code{update(reg)}}{Update the worker status.}
 \item{\code{list(reg)}}{List running jobs.}
 \item{\code{start(reg, fn, outfile)}}{Start job collection in file \dQuote{fn} and output to \dQuote{outfile}.}
 \item{\code{kill(reg, batch.id)}}{Kill job matching the \dQuote{batch.id}.}
}
}
\examples{
\dontrun{
# create a worker for the local machine and use 4 CPUs.
Worker$new("localhost", ncpus = 4)
}
}
\keyword{datasets}

