% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model_formula_tools.R
\name{deconstruct_formula}
\alias{deconstruct_formula}
\title{Deconstruct formula}
\usage{
deconstruct_formula(formula)
}
\arguments{
\item{formula}{formula object for use in statistical models.}
}
\value{
a named list with fields:
\itemize{
\item outcome (character)
\item predictors (vector of characters)
\item censor_event (character) (optional) censor event, only for formulas including a Surv() object
}
}
\description{
Deconstruct a formula object into strings of its components. Predictors are
split by '+', so interaction terms will be returned as a single string.
}
\examples{
deconstruct_formula(stats::as.formula("outcome ~ predictor1 + predictor2 + predictor3"))
deconstruct_formula(stats::as.formula("Surv(outcome, censor_event) ~ predictor"))

}
\author{
J. Peter Marquardt
}
