% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_pbp_diff.R
\name{mlb_pbp_diff}
\alias{mlb_pbp_diff}
\title{\strong{Acquire pitch-by-pitch data between two timecodes for Major and Minor League games}}
\usage{
mlb_pbp_diff(game_pk, start_timecode, end_timecode)
}
\arguments{
\item{game_pk}{The date for which you want to find game_pk values for MLB games}

\item{start_timecode}{The start time code for the MLB game (format: MMDDYYYY_HHMMSS)}

\item{end_timecode}{The end time code for the MLB game (format: MMDDYYYY_HHMMSS)}
}
\value{
Returns a tibble that includes over 100 columns of data provided
by the MLB Stats API at a pitch level between the start_timecode and end_timecode\tabular{ll}{
   col_name \tab types \cr
   game_pk \tab numeric \cr
   game_date \tab character \cr
   index \tab integer \cr
   startTime \tab character \cr
   endTime \tab character \cr
   isPitch \tab logical \cr
   type \tab character \cr
   playId \tab character \cr
   pitchNumber \tab integer \cr
   details.description \tab character \cr
   details.event \tab character \cr
   details.awayScore \tab integer \cr
   details.homeScore \tab integer \cr
   details.isScoringPlay \tab logical \cr
   details.hasReview \tab logical \cr
   details.code \tab character \cr
   details.ballColor \tab character \cr
   details.isInPlay \tab logical \cr
   details.isStrike \tab logical \cr
   details.isBall \tab logical \cr
   details.call.code \tab character \cr
   details.call.description \tab character \cr
   count.balls.start \tab integer \cr
   count.strikes.start \tab integer \cr
   count.outs.start \tab integer \cr
   player.id \tab integer \cr
   player.link \tab character \cr
   pitchData.strikeZoneTop \tab numeric \cr
   pitchData.strikeZoneBottom \tab numeric \cr
   details.fromCatcher \tab logical \cr
   pitchData.coordinates.x \tab numeric \cr
   pitchData.coordinates.y \tab numeric \cr
   hitData.trajectory \tab character \cr
   hitData.hardness \tab character \cr
   hitData.location \tab character \cr
   hitData.coordinates.coordX \tab numeric \cr
   hitData.coordinates.coordY \tab numeric \cr
   actionPlayId \tab character \cr
   details.eventType \tab character \cr
   details.runnerGoing \tab logical \cr
   position.code \tab character \cr
   position.name \tab character \cr
   position.type \tab character \cr
   position.abbreviation \tab character \cr
   battingOrder \tab character \cr
   atBatIndex \tab character \cr
   result.type \tab character \cr
   result.event \tab character \cr
   result.eventType \tab character \cr
   result.description \tab character \cr
   result.rbi \tab integer \cr
   result.awayScore \tab integer \cr
   result.homeScore \tab integer \cr
   about.atBatIndex \tab integer \cr
   about.halfInning \tab character \cr
   about.inning \tab integer \cr
   about.startTime \tab character \cr
   about.endTime \tab character \cr
   about.isComplete \tab logical \cr
   about.isScoringPlay \tab logical \cr
   about.hasReview \tab logical \cr
   about.hasOut \tab logical \cr
   about.captivatingIndex \tab integer \cr
   count.balls.end \tab integer \cr
   count.strikes.end \tab integer \cr
   count.outs.end \tab integer \cr
   matchup.batter.id \tab integer \cr
   matchup.batter.fullName \tab character \cr
   matchup.batter.link \tab character \cr
   matchup.batSide.code \tab character \cr
   matchup.batSide.description \tab character \cr
   matchup.pitcher.id \tab integer \cr
   matchup.pitcher.fullName \tab character \cr
   matchup.pitcher.link \tab character \cr
   matchup.pitchHand.code \tab character \cr
   matchup.pitchHand.description \tab character \cr
   matchup.splits.batter \tab character \cr
   matchup.splits.pitcher \tab character \cr
   matchup.splits.menOnBase \tab character \cr
   batted.ball.result \tab factor \cr
   home_team \tab character \cr
   home_level_id \tab integer \cr
   home_level_name \tab character \cr
   home_parentOrg_id \tab integer \cr
   home_parentOrg_name \tab character \cr
   home_league_id \tab integer \cr
   home_league_name \tab character \cr
   away_team \tab character \cr
   away_level_id \tab integer \cr
   away_level_name \tab character \cr
   away_parentOrg_id \tab integer \cr
   away_parentOrg_name \tab character \cr
   away_league_id \tab integer \cr
   away_league_name \tab character \cr
   batting_team \tab character \cr
   fielding_team \tab character \cr
   last.pitch.of.ab \tab character \cr
   pfxId \tab character \cr
   details.trailColor \tab character \cr
   details.type.code \tab character \cr
   details.type.description \tab character \cr
   pitchData.startSpeed \tab numeric \cr
   pitchData.endSpeed \tab numeric \cr
   pitchData.zone \tab integer \cr
   pitchData.typeConfidence \tab numeric \cr
   pitchData.plateTime \tab numeric \cr
   pitchData.extension \tab numeric \cr
   pitchData.coordinates.aY \tab numeric \cr
   pitchData.coordinates.aZ \tab numeric \cr
   pitchData.coordinates.pfxX \tab numeric \cr
   pitchData.coordinates.pfxZ \tab numeric \cr
   pitchData.coordinates.pX \tab numeric \cr
   pitchData.coordinates.pZ \tab numeric \cr
   pitchData.coordinates.vX0 \tab numeric \cr
   pitchData.coordinates.vY0 \tab numeric \cr
   pitchData.coordinates.vZ0 \tab numeric \cr
   pitchData.coordinates.x0 \tab numeric \cr
   pitchData.coordinates.y0 \tab numeric \cr
   pitchData.coordinates.z0 \tab numeric \cr
   pitchData.coordinates.aX \tab numeric \cr
   pitchData.breaks.breakAngle \tab numeric \cr
   pitchData.breaks.breakLength \tab numeric \cr
   pitchData.breaks.breakY \tab numeric \cr
   pitchData.breaks.spinRate \tab integer \cr
   pitchData.breaks.spinDirection \tab integer \cr
   hitData.launchSpeed \tab numeric \cr
   hitData.launchAngle \tab numeric \cr
   hitData.totalDistance \tab numeric \cr
   injuryType \tab character \cr
   umpire.id \tab integer \cr
   umpire.link \tab character \cr
   about.isTopInning \tab logical \cr
   matchup.postOnFirst.id \tab integer \cr
   matchup.postOnFirst.fullName \tab character \cr
   matchup.postOnFirst.link \tab character \cr
}
}
\description{
\strong{Acquire pitch-by-pitch data between two timecodes for Major and Minor League games}
}
\examples{
\donttest{
  try(mlb_pbp_diff(game_pk = 632970, 
                   start_timecode = "20210808_231704", 
                   end_timecode = "20210808_233711"))
}
}
