% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statcast.R
\name{statcast}
\alias{statcast}
\title{\strong{Statcast Functions Overview}}
\description{
\describe{
\item{\code{statcast_search()}:}{ Query Statcast by Date Range and Players.}
\item{\code{statcast_search_batters()}:}{ Query Statcast Batters by Date Range and Player.}
\item{\code{statcast_search_pitchers()}:}{ Query Statcast Pitchers by Date Range and Player.}
\item{\code{statcast_leaderboards()}:}{ Query Baseball Savant Leaderboards.}
}
}
\details{
\subsection{\strong{Query Statcast Batters by Date Range}}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{statcast_search(start_date = "2016-04-06", 
                end_date = "2016-04-15", 
                player_type = 'batter')
                            
 ## The above is equivalent to:
statcast_search_batters(start_date = "2016-04-06", 
                        end_date = "2016-04-15", 
                        batterid = NULL)
}\if{html}{\out{</div>}}
}

\subsection{\strong{Query Statcast Pitchers by Date Range}}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{statcast_search(start_date = "2016-04-06", 
                end_date = "2016-04-15", 
                player_type = 'pitcher')
                            
 ## The above is equivalent to:
statcast_search_pitchers(start_date = "2016-04-06", 
                         end_date = "2016-04-15", 
                         pitcherid = NULL)
}\if{html}{\out{</div>}}
}

\subsection{\strong{Query Statcast Batters by Date Range and Player ID}}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{  correa <- statcast_search(start_date = "2016-04-06", 
                            end_date = "2016-04-15", 
                            playerid = 621043, 
                            player_type = 'batter')
                            
 ## The above is equivalent to:
  correa <- statcast_search_batters(start_date = "2016-04-06", 
                                    end_date = "2016-04-15", 
                                    batterid = 621043)
}\if{html}{\out{</div>}}
}

\subsection{\strong{Query Statcast Pitchers by Date Range and Player ID}}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{  noah <- statcast_search(start_date = "2016-04-06",
                          end_date = "2016-04-15", 
                          playerid = 592789, 
                          player_type = 'pitcher')
                          
 ## The above is equivalent to:
  noah <- statcast_search_pitchers(start_date = "2016-04-06", 
                                  end_date = "2016-04-15", 
                                  pitcherid = 592789)
}\if{html}{\out{</div>}}
}

\subsection{\strong{Query Baseball Savant Leaderboards}}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{  statcast_leaderboards(leaderboard = "exit_velocity_barrels", year = 2021)
}\if{html}{\out{</div>}}
}
}
