% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legoplot.R
\name{legoplot3d}
\alias{legoplot3d}
\title{A wrapper function to create a sequence context "legoplot"}
\usage{
legoplot3d(contextdata, alpha = 1, scalexy = 1, gap = 0.2,
  sixcolors = "broad", theta = 50, phi = 40, gridlines = TRUE,
  labels = FALSE, zlabels = TRUE, zsub = FALSE)
}
\arguments{
\item{contextdata}{A numeric vector of counts or frequencies of the 96 possible somatic mutations and trinucleotide contexts. These MUST be in the same order as in the example (see example and/or vignette).}

\item{alpha}{The alpha channel (transparency) of the sides of 3D bars. Range 0-1.}

\item{scalexy}{Scaling factor for x and y coordinates; this constant can be used to make the plot "skinnier" or "fatter".}

\item{gap}{Gap between 3D bars.}

\item{sixcolors}{The color scheme. "broad" for Broad Institute colors, "sanger" for Sanger Institute colors or a vector of six hexadecimal RGB colors.}

\item{theta}{Polar coordinate for viewing the 3D barplot; range 0 to 360 (rotates the plot).}

\item{phi}{Polar coordinate for viewing the 3D barplot; range -90 to 90 (-90 is directly below, 90 directly above).}

\item{gridlines}{Draw gridlines on the plot (TRUE or FALSE).}

\item{labels}{Include the default axis labels (TRUE or FALSE).}

\item{zlabels}{Labels for the z axis; add numeric scale to the vertical dimension of the plot (TRUE or FALSE).}

\item{zsub}{Descriptive label for the z axis.}
}
\value{
Nothing is returned (invisibly returns NULL).
}
\description{
A wrapper function to create a sequence context "legoplot"
}
\examples{
\dontshow{
options(rgl.useNULL=TRUE)
}
# Read in COSMIC signature probabilities
x=system.file("extdata", "signature_probabilities.txt", package = "barplot3d")
sigdata=read.table(x,header=TRUE,stringsAsFactors = FALSE)
# Plot signature 2 with Sanger colors and some transparency so we can see all bars
legoplot3d(contextdata=sigdata$Signature_2,labels=TRUE,scalexy=0.05,sixcolors="sanger",
alpha=0.4,zsub="Probability")
}
