% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/banner.R
\name{banner}
\alias{banner}
\alias{section}
\alias{boxup}
\alias{open_box}
\alias{block}
\title{Make a decorated comment in an R script}
\usage{
banner(x, ..., emph = FALSE, snug = FALSE, upper = emph,
  centre = !fold, leftSideHashes = 2 + emph,
  rightSideHashes = leftSideHashes, minHashes = (!snug) * (65 + 10 *
  emph), numLines = 1 + emph, bandChar = "#", center = centre,
  fold = FALSE, maxChar = 75)

section(..., emph = TRUE, centre = TRUE, fold = TRUE)

boxup(..., rightSideHashes = 1, bandChar = "-")

open_box(..., minHashes = 0, rightSideHashes = 0, centre = FALSE,
  bandChar = "-", center)

block(..., leftSideHashes = 3, rightSideHashes = 0, centre = FALSE,
  minHashes = 0, numLines = 0, center)
}
\arguments{
\item{x}{A string, first line of the comment. If
\code{""}, the zero-length string, only the top lines of the banner are made.
If missing, in an interactive session the user will be prompted for the input
strings, one per line, in the console.}

\item{...}{Zero or more additional strings as extra lines.  Strings may contain
newline characters resulting in further line breaks.}

\item{emph}{A logical value: Do you want this to be an emphasised comment?}

\item{snug}{A logical value: Do you want the decoration to hug the strings closely?}

\item{upper}{A logical value: Do you want the strings converted to upper case?}

\item{centre}{A logical value: Do you want the text strings centred?
(alternative: left justified)}

\item{leftSideHashes}{A positive integer: How many hashes go on the left side?}

\item{rightSideHashes}{A non-negative integer: How many hashes go on the right side?}

\item{minHashes}{A non-negative integer: What is the minimum number of hashes
in the boundary lines?}

\item{numLines}{A non-negative integer: How many lines of hashes above
and below do you want?}

\item{bandChar}{A single character.  Used instead of # for all characters in
the bands around the text, apart from the first character of every line.}

\item{center}{Alternative spelling of \code{centre}.}

\item{fold}{Logical: should the text be folded to ensure lines are not too long?}

\item{maxChar}{Ingeter: maximum length allowed in any line if \code{fold} is \code{TRUE}.}
}
\value{
A character string vector returned invisibly,
but automatically displayed in the console
}
\description{
Make a decorated multi-line comment from input strings and, if possible,
transfer it to the clipboard ready for pasting into an R script (via
the \code{print} method).
}
\section{Functions}{
\itemize{
\item \code{section}: Make a prominent banner such as might be useful at the beginning
of a major code section

\item \code{boxup}: Make a minimally boxed banner comment

\item \code{open_box}: Make a boxed banner coment open at the right

\item \code{block}: Make a simple block of comment lines
}}

\examples{
banner("This should appear clearly and stand out.",
       "The lines are left justified by default.")
section("This is the first line in a section heading",
        "and this is the second\\nand this the third.")
boxup("This is a less obtrusive comment",
      "centred on multiple lines", center = TRUE, bandChar = ".")
banner("This is an important side issue.", "Take note!",
      snug = TRUE, bandChar = "=")
open_box("This is a succinctly presented comment",
         "left justified and open at the right",
         "on multiple lines")

block("This is a chatty comment.  Entering it this way just",
      "saves a tiny bit of typing but it can be useful if",
      "you need multiple initial hash marks, as you may when",
      "using Emacs/ESS, for example.",
      "Or if you want the lines centred for some odd reason.",
      center = TRUE)
## some authors like to use lines of a uniform length to separate code sections:
boxup("")
}
